/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.concurrent.Callable;
import ratpack.exec.ExecControl;
import ratpack.file.FileRenderer;
import ratpack.file.MimeTypes;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.http.Response;
import ratpack.render.RendererSupport;
import ratpack.util.ExceptionUtils;

public class DefaultFileRenderer
extends RendererSupport<Path>
implements FileRenderer {
    @Override
    public void render(final Context context, final Path targetFile) throws Exception {
        DefaultFileRenderer.readAttributes(context, targetFile, (Action<? super BasicFileAttributes>)new Action<BasicFileAttributes>(){

            @Override
            public void execute(BasicFileAttributes attributes) throws Exception {
                if (attributes == null || !attributes.isRegularFile()) {
                    context.clientError(404);
                } else {
                    DefaultFileRenderer.sendFile(context, targetFile, attributes);
                }
            }
        });
    }

    public static void sendFile(final Context context, final Path file, final BasicFileAttributes attributes) {
        if (!context.getRequest().getMethod().isGet()) {
            context.clientError(405);
            return;
        }
        Date date = new Date(attributes.lastModifiedTime().toMillis());
        context.lastModified(date, new Runnable(){

            @Override
            public void run() {
                String ifNoneMatch = context.getRequest().getHeaders().get("If-None-Match");
                Response response = context.getResponse();
                if (ifNoneMatch != null && ifNoneMatch.trim().equals("*")) {
                    response.status(HttpResponseStatus.NOT_MODIFIED.code(), HttpResponseStatus.NOT_MODIFIED.reasonPhrase()).send();
                    return;
                }
                if (!response.getHeaders().contains("Content-Type")) {
                    String contentType = context.get(MimeTypes.class).getContentType(file.getFileName().toString());
                    response.contentType(contentType);
                }
                try {
                    response.sendFile(context, attributes, file);
                }
                catch (Exception e) {
                    throw ExceptionUtils.uncheck(e);
                }
            }
        });
    }

    public static void readAttributes(ExecControl execContext, final Path file, Action<? super BasicFileAttributes> then) throws Exception {
        execContext.blocking(new Callable<BasicFileAttributes>(){

            @Override
            public BasicFileAttributes call() throws Exception {
                if (Files.exists(file, new LinkOption[0])) {
                    return Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                }
                return null;
            }
        }).then(then);
    }
}

