/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import ratpack.file.BaseDirRequiredException;
import ratpack.file.FileSystemBinding;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registries;

public class FileSystemBindingHandler
implements Handler {
    private final String path;
    private final Handler handler;

    public FileSystemBindingHandler(LaunchConfig launchConfig, String path, Handler handler) {
        if (!launchConfig.isHasBaseDir()) {
            throw new BaseDirRequiredException("An application base directory is required to use this handler");
        }
        this.path = path;
        this.handler = handler;
    }

    @Override
    public void handle(Context context) {
        FileSystemBinding parentBinding = context.maybeGet(FileSystemBinding.class);
        FileSystemBinding binding = parentBinding.binding(this.path);
        if (binding == null) {
            context.clientError(404);
        } else {
            context.insert(Registries.just(FileSystemBinding.class, binding), this.handler);
        }
    }
}

