/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.internal.FactoryHandler;
import ratpack.reload.internal.ClassUtil;
import ratpack.reload.internal.ReloadableFileBackedFactory;

public class ChainBuilders {
    public static <T> Handler build(boolean reloadable, final Function<List<Handler>, ? extends T> toChainBuilder, final Action<? super T> chainBuilderAction) throws Exception {
        File classFile;
        if (reloadable && (classFile = ClassUtil.getClassFile(chainBuilderAction)) != null) {
            ReloadableFileBackedFactory<Handler> factory = new ReloadableFileBackedFactory<Handler>(classFile.toPath(), true, new ReloadableFileBackedFactory.Producer<Handler>(){

                @Override
                public Handler produce(Path file, ByteBuf bytes) throws Exception {
                    return ChainBuilders.create(toChainBuilder, chainBuilderAction);
                }
            });
            return new FactoryHandler(factory);
        }
        return ChainBuilders.create(toChainBuilder, chainBuilderAction);
    }

    private static <T> Handler create(Function<List<Handler>, ? extends T> toChainBuilder, Action<? super T> chainBuilderAction) throws Exception {
        LinkedList handlers = new LinkedList();
        T chainBuilder = toChainBuilder.apply(handlers);
        chainBuilderAction.execute(chainBuilder);
        return Handlers.chain(handlers.toArray(new Handler[handlers.size()]));
    }
}

