/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.buffer.ByteBuf;
import java.io.OutputStream;
import ratpack.func.Action;
import ratpack.http.MutableHeaders;
import ratpack.http.client.RequestSpec;
import ratpack.util.internal.ByteBufWriteThroughOutputStream;

public class RequestSpecBacking {
    private final MutableHeaders headers;
    private final ByteBuf body;
    private String method = "GET";

    public RequestSpecBacking(MutableHeaders headers, ByteBuf body) {
        this.headers = headers;
        this.body = body;
    }

    public String getMethod() {
        return this.method;
    }

    public ByteBuf getBody() {
        return this.body;
    }

    public RequestSpec asSpec() {
        return new Spec();
    }

    private class Spec
    implements RequestSpec {
        private Spec() {
        }

        @Override
        public MutableHeaders getHeaders() {
            return RequestSpecBacking.this.headers;
        }

        @Override
        public RequestSpec method(String method) {
            RequestSpecBacking.this.method = method.toUpperCase();
            return this;
        }

        @Override
        public RequestSpec.Body getBody() {
            return new BodyImpl();
        }

        @Override
        public RequestSpec body(Action<? super RequestSpec.Body> action) throws Exception {
            action.execute(this.getBody());
            return this;
        }

        private class BodyImpl
        implements RequestSpec.Body {
            private BodyImpl() {
            }

            @Override
            public RequestSpec.Body type(String contentType) {
                Spec.this.getHeaders().set((CharSequence)"Content-Type", contentType);
                return this;
            }

            @Override
            public RequestSpec.Body stream(Action<? super OutputStream> action) throws Exception {
                try (ByteBufWriteThroughOutputStream outputStream = new ByteBufWriteThroughOutputStream(RequestSpecBacking.this.body.clear());){
                    action.execute(outputStream);
                }
                return this;
            }
        }
    }
}

