/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.net.UrlEscapers;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ratpack.http.HttpUriBuilder;
import ratpack.util.internal.InternalRatpackError;

public class DefaultHttpUriBuilder
implements HttpUriBuilder {
    private static final CharMatcher HOST_NAME_ILLEGAL_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)".-")).negate().precomputed();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private String protocol = "http";
    private String host = "localhost";
    private int port = -1;
    private final List<String> pathSegments = new LinkedList<String>();
    private final Multimap<String, String> params = MultimapBuilder.linkedHashKeys().linkedListValues().build();

    public DefaultHttpUriBuilder() {
    }

    public DefaultHttpUriBuilder(URI uri) {
        this.protocol = uri.getScheme().toLowerCase();
        if (!this.protocol.equals("http") && !this.protocol.equals("https")) {
            throw new IllegalArgumentException("uri " + uri + " must be a http or https uri");
        }
        this.host(uri.getHost());
        this.port(uri.getPort());
        String rawPath = uri.getRawPath();
        if (rawPath != null && !rawPath.isEmpty() && !rawPath.equals("/")) {
            String[] parts;
            for (String part : parts = rawPath.substring(1).split("/")) {
                try {
                    String s = part.replaceAll("\\+", "%2B");
                    this.pathSegment(URLDecoder.decode(s, "UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalRatpackError("UTF8 is not available", e);
                }
            }
        }
        if (uri.getRawQuery() != null) {
            Map parameters = new QueryStringDecoder(uri).parameters();
            for (Map.Entry entry : parameters.entrySet()) {
                if (entry.getKey() == null) continue;
                this.params.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
        }
    }

    @Override
    public HttpUriBuilder secure() {
        this.protocol = "https";
        return this;
    }

    @Override
    public HttpUriBuilder host(String host) {
        int indexIn = HOST_NAME_ILLEGAL_CHARS.indexIn((CharSequence)host);
        if (indexIn >= 0) {
            throw new IllegalArgumentException("character '" + host.charAt(indexIn) + "' of host name '" + host + "' is invalid (only [a-zA-Z0-9.-] are allowed in host names)");
        }
        this.host = host;
        return this;
    }

    @Override
    public HttpUriBuilder port(int port) {
        if (port == 0 || port < -1) {
            throw new IllegalArgumentException("port must be greater than 0 or exactly -1, is " + port);
        }
        this.port = port;
        return this;
    }

    @Override
    public HttpUriBuilder path(String path) {
        Objects.requireNonNull(path, "path must not be null");
        Collections.addAll(this.pathSegments, path.split("/"));
        return this;
    }

    @Override
    public HttpUriBuilder pathSegment(String pathSegment) {
        Objects.requireNonNull(pathSegment, "pathSegment must not be null");
        this.pathSegments.add(pathSegment);
        return this;
    }

    @Override
    public HttpUriBuilder params(String ... params) {
        int i = 0;
        while (i < params.length) {
            String key = params[i];
            String value = "";
            if (++i < params.length) {
                value = params[i++];
            }
            this.params.put((Object)key, (Object)value);
        }
        return this;
    }

    @Override
    public HttpUriBuilder params(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.params.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    @Override
    public HttpUriBuilder params(Multimap<String, String> params) {
        this.params.putAll(params);
        return this;
    }

    @Override
    public URI build() {
        String string = this.toString();
        try {
            return new URI(string);
        }
        catch (URISyntaxException e) {
            throw new InternalRatpackError("HttpUriBuilder produced invalid URI: " + this.toString(), e);
        }
    }

    private void appendPathString(StringBuilder stringBuilder) {
        if (!this.pathSegments.isEmpty()) {
            stringBuilder.append("/");
            PATH_JOINER.appendTo(stringBuilder, Iterables.transform(this.pathSegments, (Function)new Function<String, String>(){

                public String apply(String input) {
                    return UrlEscapers.urlPathSegmentEscaper().escape(input);
                }
            }));
        }
    }

    private void appendQueryString(StringBuilder stringBuilder) {
        if (!this.params.isEmpty()) {
            stringBuilder.append("?");
            Iterator parts = this.params.entries().iterator();
            if (parts.hasNext()) {
                Map.Entry entry = (Map.Entry)parts.next();
                stringBuilder.append(UrlEscapers.urlFormParameterEscaper().escape((String)entry.getKey()));
                String value = (String)entry.getValue();
                if (value != null && value.length() > 0) {
                    stringBuilder.append("=");
                    stringBuilder.append(UrlEscapers.urlFormParameterEscaper().escape(value));
                }
                while (parts.hasNext()) {
                    stringBuilder.append("&");
                    Map.Entry e = (Map.Entry)parts.next();
                    stringBuilder.append(UrlEscapers.urlFormParameterEscaper().escape((String)e.getKey()));
                    String v = (String)e.getValue();
                    if (v == null || v.length() <= 0) continue;
                    stringBuilder.append("=");
                    stringBuilder.append(UrlEscapers.urlFormParameterEscaper().escape(v));
                }
            }
        }
    }

    public String toString() {
        StringBuilder uri = new StringBuilder(this.protocol).append("://").append(this.host);
        if (this.port > -1) {
            uri.append(":").append(this.port);
        }
        this.appendPathString(uri);
        this.appendQueryString(uri);
        return uri.toString();
    }
}

