/*
 * Decompiled with CFR 0.152.
 */
package ratpack.launch;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import ratpack.exec.ExecController;
import ratpack.file.FileSystemBinding;
import ratpack.launch.HandlerFactory;
import ratpack.launch.NoBaseDirException;
import ratpack.launch.NoHandlerFactoryException;

public interface LaunchConfig {
    public static final int DEFAULT_PORT = 5050;
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 0x100000;
    public static final int DEFAULT_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    public static final long DEFAULT_COMPRESSION_MIN_SIZE = 1024L;

    public FileSystemBinding getBaseDir() throws NoBaseDirException;

    public HandlerFactory getHandlerFactory() throws NoHandlerFactoryException;

    public int getPort();

    public InetAddress getAddress();

    public boolean isReloadable();

    public int getThreads();

    public ExecController getExecController();

    public ByteBufAllocator getBufferAllocator();

    public URI getPublicAddress();

    public List<String> getIndexFiles();

    public SSLContext getSSLContext();

    public String getOther(String var1, String var2);

    public Map<String, String> getOtherPrefixedWith(String var1);

    public int getMaxContentLength();

    public boolean isTimeResponses();

    public boolean isCompressResponses();

    public long getCompressionMinSize();

    public ImmutableSet<String> getCompressionMimeTypeWhiteList();

    public ImmutableSet<String> getCompressionMimeTypeBlackList();

    public boolean isHasBaseDir();
}

