/*
 * Decompiled with CFR 0.152.
 */
package ratpack.parse;

import com.google.common.reflect.TypeToken;
import ratpack.parse.NullParseOpts;

public class Parse<T, O> {
    private final TypeToken<T> type;
    private final O opts;

    private Parse(TypeToken<T> type, O opts) {
        this.type = type;
        this.opts = opts;
    }

    public TypeToken<T> getType() {
        return this.type;
    }

    public O getOpts() {
        return this.opts;
    }

    public static <T, O> Parse<T, O> of(TypeToken<T> type, O opts) {
        return new Parse<T, O>(type, opts);
    }

    public static <T> Parse<T, NullParseOpts> of(TypeToken<T> type) {
        return Parse.of(type, NullParseOpts.INSTANCE);
    }

    public static <T, O> Parse<T, O> of(Class<T> type, O opts) {
        return new Parse<T, O>(TypeToken.of(type), opts);
    }

    public static <T> Parse<T, NullParseOpts> of(Class<T> type) {
        return Parse.of(type, NullParseOpts.INSTANCE);
    }
}

