/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.reflect.TypeToken;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ratpack.func.Factory;
import ratpack.registry.internal.RegistryEntry;

public class LazyRegistryEntry<T>
implements RegistryEntry<T> {
    private final TypeToken<T> type;
    private final Factory<? extends T> factory;
    private final Lock lock = new ReentrantLock();
    private T object;

    public LazyRegistryEntry(TypeToken<T> type, Factory<? extends T> factory) {
        this.type = type;
        this.factory = factory;
    }

    @Override
    public TypeToken<T> getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.object == null) {
            this.lock.lock();
            try {
                if (this.object == null) {
                    this.object = this.factory.create();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.object;
    }
}

