/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.List;
import ratpack.func.Action;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.internal.RegistryEntry;

public class MultiEntryRegistry
implements Registry {
    private final List<? extends RegistryEntry<?>> entries;

    public MultiEntryRegistry(List<? extends RegistryEntry<?>> entries) {
        this.entries = entries;
    }

    public String toString() {
        return "Registry{" + this.entries + '}';
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.get(TypeToken.of(type));
    }

    @Override
    public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        O object = this.maybeGet(type);
        if (object == null) {
            throw new NotInRegistryException(type);
        }
        return object;
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        return this.maybeGet(TypeToken.of(type));
    }

    @Override
    public <O> O maybeGet(TypeToken<O> type) {
        for (RegistryEntry<?> entry : this.entries) {
            if (!type.isAssignableFrom(entry.getType())) continue;
            Object cast = entry.get();
            return (O)cast;
        }
        return null;
    }

    @Override
    public <O> Iterable<? extends O> getAll(Class<O> type) {
        return this.getAll(TypeToken.of(type));
    }

    @Override
    public <O> Iterable<? extends O> getAll(final TypeToken<O> type) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new Iterator<O>(){
                    final Iterator<? extends RegistryEntry<?>> delegate;
                    O next;
                    {
                        this.delegate = MultiEntryRegistry.this.entries.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        while (this.delegate.hasNext()) {
                            RegistryEntry<?> entry = this.delegate.next();
                            if (!type.isAssignableFrom(entry.getType())) continue;
                            Object cast = entry.get();
                            this.next = cast;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public O next() {
                        Object nextCopy = this.next;
                        this.next = null;
                        return nextCopy;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public <O> O first(TypeToken<O> type, Predicate<? super O> predicate) {
        for (RegistryEntry<?> entry : this.entries) {
            Object cast;
            if (!type.isAssignableFrom(entry.getType()) || !predicate.apply(cast = entry.get())) continue;
            return (O)cast;
        }
        return null;
    }

    public <O> Iterable<? extends O> all(TypeToken<O> type, Predicate<? super O> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RegistryEntry<?> entry : this.entries) {
            Object cast;
            if (!type.isAssignableFrom(entry.getType()) || !predicate.apply(cast = entry.get())) continue;
            builder.add(cast);
        }
        return builder.build();
    }

    public <O> boolean each(TypeToken<O> type, Predicate<? super O> predicate, Action<? super O> action) throws Exception {
        boolean foundMatch = false;
        for (RegistryEntry<?> entry : this.entries) {
            Object cast;
            if (!type.isAssignableFrom(entry.getType()) || !predicate.apply(cast = entry.get())) continue;
            action.execute(cast);
            foundMatch = true;
        }
        return foundMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiEntryRegistry that = (MultiEntryRegistry)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }
}

