/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.registry.MutableRegistry;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.internal.DefaultRegistryEntry;
import ratpack.registry.internal.LazyRegistryEntry;
import ratpack.registry.internal.MultiEntryRegistry;
import ratpack.registry.internal.RegistryEntry;
import ratpack.util.Types;

public class SimpleMutableRegistry
implements MutableRegistry {
    private final List<RegistryEntry<?>> entries = new LinkedList();
    private final Registry registry = new MultiEntryRegistry(this.entries);

    @Override
    public <T> void register(Class<T> type, T object) {
        this.entries.add(new DefaultRegistryEntry<T>(TypeToken.of(type), object));
    }

    @Override
    public void register(Object object) {
        this.doRegister(object);
    }

    private <T> void doRegister(T object) {
        Class type = (Class)Types.cast(object.getClass());
        TypeToken typeToken = TypeToken.of((Class)type);
        this.entries.add(new DefaultRegistryEntry<T>(typeToken, object));
    }

    @Override
    public <T> void registerLazy(Class<T> type, Factory<? extends T> factory) {
        this.entries.add(new LazyRegistryEntry<T>(TypeToken.of(type), factory));
    }

    @Override
    public <T> void remove(Class<T> type) throws NotInRegistryException {
        Iterator<RegistryEntry<?>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getType().isAssignableFrom(type)) continue;
            iterator.remove();
        }
    }

    public <T> T get(Class<T> type) throws NotInRegistryException {
        return this.registry.get(type);
    }

    public <T> T maybeGet(Class<T> type) {
        return this.registry.maybeGet(type);
    }

    public <T> Iterable<? extends T> getAll(Class<T> type) {
        return this.registry.getAll(type);
    }

    public <T> T get(TypeToken<T> type) throws NotInRegistryException {
        return this.registry.get(type);
    }

    public <T> T maybeGet(TypeToken<T> type) {
        return this.registry.maybeGet(type);
    }

    public <T> Iterable<? extends T> getAll(TypeToken<T> type) {
        return this.registry.getAll(type);
    }

    @Override
    public <T> T first(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.registry.first(type, predicate);
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.registry.all(type, predicate);
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        return this.registry.each(type, predicate, action);
    }
}

