/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import ratpack.func.Action;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.internal.RegistryEntry;

public class SingleEntryRegistry
implements Registry {
    private final RegistryEntry<?> entry;

    public SingleEntryRegistry(RegistryEntry<?> entry) {
        this.entry = entry;
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.get(TypeToken.of(type));
    }

    @Override
    public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        O value = this.maybeGet(type);
        if (value == null) {
            throw new NotInRegistryException(type);
        }
        return value;
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        return this.maybeGet(TypeToken.of(type));
    }

    @Override
    public <O> O maybeGet(TypeToken<O> type) {
        if (type.isAssignableFrom(this.entry.getType())) {
            Object cast = this.entry.get();
            return (O)cast;
        }
        return null;
    }

    @Override
    public <O> Iterable<? extends O> getAll(Class<O> type) {
        return this.getAll(TypeToken.of(type));
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        O value = this.maybeGet(type);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(value);
    }

    @Override
    public <T> T first(TypeToken<T> type, Predicate<? super T> predicate) {
        T value = this.maybeGet(type);
        if (value != null && predicate.apply(value)) {
            return value;
        }
        return null;
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        T value = this.first(type, predicate);
        if (value != null) {
            return ImmutableList.of(value);
        }
        return ImmutableList.of();
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        T first = this.first(type, predicate);
        if (first == null) {
            return false;
        }
        action.execute(first);
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleEntryRegistry that = (SingleEntryRegistry)o;
        return this.entry.equals(that.entry);
    }

    public int hashCode() {
        return this.entry.hashCode();
    }
}

