/*
 * Decompiled with CFR 0.152.
 */
package ratpack.render.internal;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import ratpack.handling.Context;
import ratpack.render.NoSuchRendererException;
import ratpack.render.Renderer;
import ratpack.render.RendererException;
import ratpack.render.internal.RenderController;

public class DefaultRenderController
implements RenderController {
    private static final TypeToken<Renderer<?>> RENDERER_TYPE_TOKEN = new TypeToken<Renderer<?>>(){
        private static final long serialVersionUID = 0L;
    };

    @Override
    public void render(Object toRender, Context context) throws Exception {
        if (toRender == null) {
            context.clientError(404);
            return;
        }
        Renderer<?> renderer = context.first(RENDERER_TYPE_TOKEN, new RendererForTypePredicate(toRender.getClass()));
        if (renderer == null) {
            throw new NoSuchRendererException(toRender);
        }
        try {
            this.doRender(toRender, renderer, context);
        }
        catch (Exception e) {
            throw new RendererException(renderer, toRender, e);
        }
    }

    private <T> void doRender(Object object, Renderer<T> renderer, Context context) throws Exception {
        Object cast = object;
        renderer.render(context, cast);
    }

    private static class RendererForTypePredicate
    implements Predicate<Renderer<?>> {
        private final Class<?> toRenderType;

        public RendererForTypePredicate(Class<?> toRenderType) {
            this.toRenderType = toRenderType;
        }

        public boolean apply(Renderer<?> renderer) {
            return renderer.getType().isAssignableFrom(this.toRenderType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RendererForTypePredicate that = (RendererForTypePredicate)o;
            return this.toRenderType.equals(that.toRenderType);
        }

        public int hashCode() {
            return this.toRenderType.hashCode();
        }
    }
}

