/*
 * Decompiled with CFR 0.152.
 */
package ratpack.websocket.internal;

import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.util.ExceptionUtils;
import ratpack.websocket.WebSocket;
import ratpack.websocket.WebSocketClose;
import ratpack.websocket.WebSocketHandler;
import ratpack.websocket.WebSocketMessage;

public class BuiltWebSocketHandler<T>
implements WebSocketHandler<T> {
    private final Function<? super WebSocket, T> open;
    private final Action<? super WebSocketClose<T>> close;
    private final Action<? super WebSocketMessage<T>> message;

    public BuiltWebSocketHandler(Function<? super WebSocket, T> open, Action<? super WebSocketClose<T>> close, Action<? super WebSocketMessage<T>> message) {
        this.open = open;
        this.close = close;
        this.message = message;
    }

    @Override
    public T onOpen(WebSocket webSocket) throws Exception {
        return this.open.apply(webSocket);
    }

    @Override
    public void onClose(WebSocketClose<T> close) {
        try {
            this.close.execute(close);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    @Override
    public void onMessage(WebSocketMessage<T> frame) {
        try {
            this.message.execute(frame);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }
}

