/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecStarter;
import ratpack.exec.UnmanagedThreadException;
import ratpack.exec.internal.ThreadBinding;

public interface ExecController
extends AutoCloseable {
    public static Optional<ExecController> current() {
        return ThreadBinding.get().map(ThreadBinding::getExecController);
    }

    public static ExecController require() throws UnmanagedThreadException {
        return ExecController.current().orElseThrow(UnmanagedThreadException::new);
    }

    public ExecStarter fork();

    public ScheduledExecutorService getExecutor();

    public ExecutorService getBlockingExecutor();

    public EventLoopGroup getEventLoopGroup();

    public int getNumThreads();

    @Override
    public void close();

    default public void awaitShutdown() throws InterruptedException {
        this.awaitShutdown(Duration.ofSeconds(60L));
    }

    default public void awaitShutdown(Duration duration) throws InterruptedException {
        boolean inEventLoop = false;
        for (EventExecutor eventExecutor : this.getEventLoopGroup().children()) {
            if (!eventExecutor.inEventLoop()) continue;
            inEventLoop = true;
            break;
        }
        long toWaitMillis = duration.toMillis();
        if (!inEventLoop) {
            long start = System.currentTimeMillis();
            this.getEventLoopGroup().awaitTermination(toWaitMillis, TimeUnit.MILLISECONDS);
            toWaitMillis -= System.currentTimeMillis() - start;
        }
        this.getBlockingExecutor().awaitTermination(Math.max(1L, toWaitMillis), TimeUnit.MILLISECONDS);
    }
}

