/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import io.netty.channel.EventLoop;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.Downstream;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInitializer;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.ExecutionException;
import ratpack.exec.OverlappingExecutionException;
import ratpack.exec.UnmanagedThreadException;
import ratpack.exec.Upstream;
import ratpack.exec.internal.ExecControllerInternal;
import ratpack.func.Action;
import ratpack.func.Block;
import ratpack.registry.MutableRegistry;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.RegistrySpec;
import ratpack.registry.internal.SimpleMutableRegistry;
import ratpack.stream.Streams;
import ratpack.stream.TransformablePublisher;

public class DefaultExecution
implements Execution {
    static final Logger LOGGER = LoggerFactory.getLogger(Execution.class);
    public static final ThreadLocal<DefaultExecution> THREAD_BINDING = new ThreadLocal();
    StreamHandle streamHandle;
    private final ExecControllerInternal controller;
    private final EventLoop eventLoop;
    private final Action<? super Throwable> onError;
    private final Action<? super Execution> onComplete;
    private final List<AutoCloseable> closeables = Lists.newArrayListWithCapacity((int)0);
    private final MutableRegistry registry = new SimpleMutableRegistry();
    private final List<ExecInterceptor> adhocInterceptors = Lists.newArrayListWithCapacity((int)0);
    private final Iterable<? extends ExecInterceptor> interceptors;
    private boolean done;

    public DefaultExecution(ExecControllerInternal controller, EventLoop eventLoop, Action<? super RegistrySpec> registryInit, Action<? super Execution> action, Action<? super Throwable> onError, Action<? super Execution> onStart, Action<? super Execution> onComplete) throws Exception {
        this.controller = controller;
        this.eventLoop = eventLoop;
        this.onError = onError;
        this.onComplete = onComplete;
        registryInit.execute(this.registry);
        onStart.execute(this);
        this.streamHandle = new InitialStreamHandle();
        ArrayDeque<UserCode> event = new ArrayDeque<UserCode>();
        event.add(() -> action.execute(this));
        this.streamHandle.stream.add(event);
        this.interceptors = Iterables.concat(controller.getInterceptors(), (Iterable)ImmutableList.copyOf(this.registry.getAll(ExecInterceptor.class)), this.adhocInterceptors);
        for (ExecInitializer initializer : controller.getInitializers()) {
            initializer.init(this);
        }
        for (ExecInitializer initializer : this.registry.getAll(ExecInitializer.class)) {
            initializer.init(this);
        }
        this.drain();
    }

    public static DefaultExecution get() throws UnmanagedThreadException {
        return THREAD_BINDING.get();
    }

    public static DefaultExecution require() throws UnmanagedThreadException {
        DefaultExecution executionBacking = DefaultExecution.get();
        if (executionBacking == null) {
            throw new UnmanagedThreadException();
        }
        return executionBacking;
    }

    public static <T> TransformablePublisher<T> stream(Publisher<T> publisher) {
        return Streams.transformable(subscriber -> DefaultExecution.require().streamSubscribe(handle -> publisher.subscribe(new Subscriber<T>((StreamHandle)handle, subscriber){
            final /* synthetic */ StreamHandle val$handle;
            final /* synthetic */ Subscriber val$cap$1;
            {
                this.val$handle = streamHandle;
                this.val$cap$1 = subscriber;
            }

            public void onSubscribe(Subscription subscription) {
                this.val$handle.event(() -> this.val$cap$1.onSubscribe(subscription));
            }

            public void onNext(T element) {
                this.val$handle.event(() -> this.val$cap$1.onNext(element));
            }

            public void onComplete() {
                this.val$handle.complete(() -> ((Subscriber)this.val$cap$1).onComplete());
            }

            public void onError(Throwable cause) {
                this.val$handle.complete(() -> this.val$cap$1.onError(cause));
            }
        })));
    }

    public static <T> Upstream<T> upstream(Upstream<T> upstream) {
        return downstream -> {
            final AtomicBoolean fired = new AtomicBoolean();
            DefaultExecution.require().streamSubscribe(handle -> {
                try {
                    upstream.connect(new Downstream<T>((StreamHandle)handle, downstream){
                        final /* synthetic */ StreamHandle val$handle;
                        final /* synthetic */ Downstream val$cap$2;
                        {
                            this.val$handle = streamHandle;
                            this.val$cap$2 = downstream;
                        }

                        @Override
                        public void error(Throwable throwable) {
                            if (!fired.compareAndSet(false, true)) {
                                LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled", throwable));
                                return;
                            }
                            this.val$handle.complete(() -> this.val$cap$2.error(throwable));
                        }

                        @Override
                        public void success(T value) {
                            if (!fired.compareAndSet(false, true)) {
                                LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled"));
                                return;
                            }
                            this.val$handle.complete(() -> this.val$cap$2.success(value));
                        }

                        @Override
                        public void complete() {
                            if (!fired.compareAndSet(false, true)) {
                                LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled"));
                                return;
                            }
                            this.val$handle.complete(this.val$cap$2::complete);
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (!fired.compareAndSet(false, true)) {
                        LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled", throwable));
                        return;
                    }
                    handle.complete(() -> downstream.error(throwable));
                }
            });
        };
    }

    @Override
    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public void streamSubscribe(Action<? super StreamHandle> consumer) {
        if (this.done) {
            throw new ExecutionException("this execution has completed (you may be trying to use a promise in a cleanup method)");
        }
        if (this.streamHandle.stream.isEmpty()) {
            this.streamHandle.stream.add(new ArrayDeque());
        }
        this.streamHandle.stream.element().add(() -> {
            StreamHandle parent = this.streamHandle;
            this.streamHandle = new StreamHandle(parent);
            consumer.execute(this.streamHandle);
        });
        this.drain();
    }

    public void eventLoopDrain() {
        this.eventLoop.execute(this::drain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        if (this.done) {
            return;
        }
        DefaultExecution threadBoundExecutionBacking = THREAD_BINDING.get();
        if (this.equals(threadBoundExecutionBacking)) {
            return;
        }
        if (!this.eventLoop.inEventLoop() || threadBoundExecutionBacking != null) {
            if (!this.done) {
                this.eventLoop.execute(this::drain);
            }
            return;
        }
        try {
            THREAD_BINDING.set(this);
            while (true) {
                if (this.streamHandle.stream.isEmpty()) {
                    return;
                }
                Block segment = this.streamHandle.stream.element().poll();
                if (segment == null) {
                    this.streamHandle.stream.remove();
                    if (!this.streamHandle.stream.isEmpty()) continue;
                    if (this.streamHandle.getClass().equals(InitialStreamHandle.class)) {
                        this.done();
                        return;
                    }
                    break;
                }
                if (segment instanceof UserCode) {
                    try {
                        this.intercept(ExecInterceptor.ExecType.COMPUTE, segment);
                    }
                    catch (Throwable e) {
                        Deque<Block> event = this.streamHandle.stream.element();
                        event.clear();
                        event.addFirst(() -> {
                            try {
                                this.onError.execute(e);
                            }
                            catch (Throwable errorHandlerException) {
                                this.streamHandle.stream.element().addFirst(() -> {
                                    throw errorHandlerException;
                                });
                            }
                        });
                    }
                    continue;
                }
                try {
                    segment.execute();
                }
                catch (Exception e) {
                    LOGGER.error("Internal Ratpack Error - please raise an issue", (Throwable)e);
                }
            }
        }
        finally {
            THREAD_BINDING.remove();
        }
    }

    private void intercept(ExecInterceptor.ExecType execType, Block segment) throws Exception {
        Iterator<? extends ExecInterceptor> iterator = this.getAllInterceptors().iterator();
        this.intercept(execType, iterator, segment);
    }

    public Iterable<? extends ExecInterceptor> getAllInterceptors() {
        return this.interceptors;
    }

    private void done() {
        this.done = true;
        try {
            this.onComplete.execute(this);
        }
        catch (Throwable e) {
            LOGGER.warn("exception raised during onComplete action", e);
        }
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                LOGGER.warn(String.format("exception raised by closeable %s", closeable), e);
            }
        }
    }

    public void intercept(ExecInterceptor.ExecType execType, Iterator<? extends ExecInterceptor> interceptors, Block action) throws Exception {
        if (interceptors.hasNext()) {
            interceptors.next().intercept(this, execType, () -> this.intercept(execType, interceptors, action));
        } else {
            action.execute();
        }
    }

    @Override
    public ExecController getController() {
        return this.controller;
    }

    @Override
    public void onComplete(AutoCloseable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public <O> Execution addLazy(TypeToken<O> type, Supplier<? extends O> supplier) {
        this.registry.addLazy(type, supplier);
        return this;
    }

    @Override
    public void addInterceptor(ExecInterceptor execInterceptor, Block continuation) throws Exception {
        this.adhocInterceptors.add(execInterceptor);
        this.intercept(ExecInterceptor.ExecType.COMPUTE, Collections.singletonList(execInterceptor).iterator(), continuation);
    }

    @Override
    public <T> void remove(TypeToken<T> type) throws NotInRegistryException {
        this.registry.remove(type);
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        return this.registry.maybeGet(type);
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.registry.getAll(type);
    }

    public class StreamHandle {
        final StreamHandle parent;
        final Queue<Deque<Block>> stream = new ConcurrentLinkedQueue<Deque<Block>>();

        private StreamHandle(StreamHandle parent) {
            this.parent = parent;
            this.stream.add(new ArrayDeque());
        }

        public void event(UserCode action) {
            this.streamEvent(action);
        }

        public void complete(UserCode action) {
            this.streamEvent(() -> {
                DefaultExecution.this.streamHandle = this.parent;
                action.execute();
            });
        }

        public void complete() {
            this.streamEvent(() -> {
                DefaultExecution.this.streamHandle = this.parent;
            });
        }

        private void streamEvent(Block s) {
            ArrayDeque<Block> event = new ArrayDeque<Block>();
            event.add(s);
            this.stream.add(event);
            DefaultExecution.this.drain();
        }
    }

    public static interface UserCode
    extends Block {
    }

    private class InitialStreamHandle
    extends StreamHandle {
        public InitialStreamHandle() {
            super(null);
        }
    }
}

