/*
 * Decompiled with CFR 0.152.
 */
package ratpack.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import ratpack.func.Function;
import ratpack.handling.Context;
import ratpack.server.ServerConfig;
import ratpack.stream.Streams;
import ratpack.websocket.AutoCloseWebSocketHandler;
import ratpack.websocket.WebSocket;
import ratpack.websocket.WebSocketConnector;
import ratpack.websocket.WebSocketHandler;
import ratpack.websocket.internal.DefaultWebSocketConnector;
import ratpack.websocket.internal.WebSocketEngine;
import ratpack.websocket.internal.WebsocketBroadcastSubscriber;

public abstract class WebSockets {
    public static <T> WebSocketConnector<T> websocket(Context context, Function<WebSocket, T> openAction) {
        return new DefaultWebSocketConnector<T>(context, openAction);
    }

    public static void websocket(Context context, WebSocketHandler<?> handler) {
        WebSocketEngine.connect(context, "/", context.get(ServerConfig.class).getMaxContentLength(), handler);
    }

    public static void websocketBroadcast(Context context, Publisher<String> broadcaster) {
        ByteBufAllocator bufferAllocator = context.get(ByteBufAllocator.class);
        WebSockets.websocketByteBufBroadcast(context, Streams.map(broadcaster, s -> ByteBufUtil.encodeString((ByteBufAllocator)bufferAllocator, (CharBuffer)CharBuffer.wrap(s), (Charset)CharsetUtil.UTF_8)));
    }

    public static void websocketByteBufBroadcast(Context context, final Publisher<ByteBuf> broadcaster) {
        WebSockets.websocket(context, new AutoCloseWebSocketHandler<AutoCloseable>(){

            @Override
            public AutoCloseable onOpen(WebSocket webSocket) throws Exception {
                WebsocketBroadcastSubscriber subscriber = new WebsocketBroadcastSubscriber(webSocket);
                Streams.bindExec(broadcaster).subscribe(subscriber);
                return subscriber;
            }
        });
    }
}

