/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import ratpack.config.ConfigData;
import ratpack.config.ConfigObject;
import ratpack.config.ConfigSource;
import ratpack.config.internal.ConfigDataLoader;
import ratpack.config.internal.DefaultConfigObject;
import ratpack.file.FileSystemBinding;
import ratpack.util.Exceptions;

public class DefaultConfigData
implements ConfigData {
    private final ObjectMapper objectMapper;
    private final ObjectNode rootNode;
    private final ObjectNode emptyNode;

    public DefaultConfigData(ObjectMapper objectMapper, Iterable<ConfigSource> configSources, FileSystemBinding fileSystemBinding) {
        this.objectMapper = objectMapper;
        ConfigDataLoader loader = new ConfigDataLoader(this.objectMapper, configSources, fileSystemBinding);
        this.rootNode = loader.load();
        this.emptyNode = this.objectMapper.getNodeFactory().objectNode();
    }

    @Override
    public ObjectNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public <O> ConfigObject<O> getAsConfigObject(String pointer, TypeToken<O> type) {
        ObjectNode node;
        Object object = node = pointer != null ? this.rootNode.at(pointer) : this.rootNode;
        if (node.isMissingNode()) {
            node = this.emptyNode;
        }
        try {
            JavaType javaType = this.objectMapper.getTypeFactory().constructType(type.getType());
            Object value = this.objectMapper.readValue((JsonParser)new TreeTraversingParser((JsonNode)node, (ObjectCodec)this.objectMapper), javaType);
            return new DefaultConfigObject<Object>(pointer, type, value);
        }
        catch (IOException ex) {
            throw Exceptions.uncheck((Throwable)ex);
        }
    }
}

