/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLException;
import ratpack.http.client.internal.HttpChannelKey;
import ratpack.http.client.internal.ProxyInternal;

public class ProxyChannelPoolHandler
extends AbstractChannelPoolHandler {
    private final String host;
    private final ProxyInternal proxy;

    public ProxyChannelPoolHandler(HttpChannelKey channelKey) {
        this.host = channelKey.host;
        this.proxy = channelKey.proxy;
    }

    public void channelCreated(Channel ch) throws Exception {
        if (this.proxy != null && this.proxy.shouldProxy(this.host)) {
            InetSocketAddress proxyAddress = new InetSocketAddress(this.proxy.getHost(), this.proxy.getPort());
            if (this.proxy.useSsl()) {
                ch.pipeline().addLast(new ChannelHandler[]{this.createSslHandler(ch)});
            }
            if (this.proxy.getCredentials() != null) {
                ch.pipeline().addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyAddress, this.proxy.getCredentials().getUsername(), this.proxy.getCredentials().getPassword())});
            } else {
                ch.pipeline().addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyAddress)});
            }
        }
    }

    private SslHandler createSslHandler(Channel ch) throws SSLException {
        SslContext sslCtx = this.proxy.getSslContext();
        if (sslCtx == null) {
            sslCtx = SslContextBuilder.forClient().build();
        }
        return sslCtx.newHandler(ch.alloc(), this.proxy.getHost(), this.proxy.getPort());
    }
}

