/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import java.net.URI;
import ratpack.server.PublicAddress;
import ratpack.server.RatpackServer;

public class ServerBindPublicAddress
implements PublicAddress {
    private final RatpackServer server;

    public ServerBindPublicAddress(RatpackServer server) {
        this.server = server;
    }

    @Override
    public URI get() {
        if (this.server.isRunning()) {
            String scheme = this.server.getScheme();
            int port = this.server.getBindPort();
            String portSuffix = scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443 ? "" : ":" + port;
            return URI.create(scheme + "://" + this.server.getBindHost() + portSuffix);
        }
        throw new IllegalStateException("Server has not yet started");
    }
}

