/*
 * Decompiled with CFR 0.152.
 */
package ratpack.bytebuf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ByteProcessor;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public class ByteBufRef
extends ByteBuf {
    protected final RefReferenceCounting counted;
    protected final ByteBuf delegate;

    public ByteBufRef(ByteBuf delegate) {
        this.delegate = delegate;
        this.counted = new RefReferenceCounting();
    }

    private ByteBufRef(RefReferenceCounting counted, ByteBuf delegate) {
        this.counted = counted;
        this.delegate = delegate;
    }

    protected void deallocate() {
        this.delegate.release();
    }

    private ByteBufRef wrap(ByteBuf delegate) {
        return new ByteBufRef(this.counted, delegate);
    }

    public ByteBuf retain(int increment) {
        this.touch();
        this.counted.retain(increment);
        return this;
    }

    public ByteBuf retain() {
        this.touch();
        this.counted.retain();
        return this;
    }

    public boolean release() {
        this.touch();
        return this.counted.release();
    }

    public boolean release(int decrement) {
        this.touch();
        return this.counted.release(decrement);
    }

    public int refCnt() {
        return this.counted.refCnt();
    }

    public int capacity() {
        return this.delegate.capacity();
    }

    public ByteBuf capacity(int newCapacity) {
        this.delegate.capacity(newCapacity);
        return this;
    }

    public int maxCapacity() {
        return this.delegate.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.delegate.alloc();
    }

    @Deprecated
    public ByteOrder order() {
        return this.delegate.order();
    }

    @Deprecated
    public ByteBuf order(ByteOrder endianness) {
        this.delegate.order(endianness);
        return this;
    }

    public ByteBuf unwrap() {
        return this.delegate;
    }

    public boolean isDirect() {
        return this.delegate.isDirect();
    }

    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        if (this.delegate.isReadOnly()) {
            return this;
        }
        return this.wrap(this.delegate.asReadOnly());
    }

    public int readerIndex() {
        return this.delegate.readerIndex();
    }

    public ByteBuf readerIndex(int readerIndex) {
        this.delegate.readerIndex(readerIndex);
        return this;
    }

    public int writerIndex() {
        return this.delegate.writerIndex();
    }

    public ByteBuf writerIndex(int writerIndex) {
        this.delegate.writerIndex(writerIndex);
        return this;
    }

    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        this.delegate.setIndex(readerIndex, writerIndex);
        return this;
    }

    public int readableBytes() {
        return this.delegate.readableBytes();
    }

    public int writableBytes() {
        return this.delegate.writableBytes();
    }

    public int maxWritableBytes() {
        return this.delegate.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.delegate.isReadable();
    }

    public boolean isReadable(int size) {
        return this.delegate.isReadable(size);
    }

    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    public boolean isWritable(int size) {
        return this.delegate.isWritable(size);
    }

    public ByteBuf clear() {
        this.delegate.clear();
        return this;
    }

    public ByteBuf markReaderIndex() {
        this.delegate.markReaderIndex();
        return this;
    }

    public ByteBuf resetReaderIndex() {
        this.delegate.resetReaderIndex();
        return this;
    }

    public ByteBuf markWriterIndex() {
        this.delegate.markWriterIndex();
        return this;
    }

    public ByteBuf resetWriterIndex() {
        this.delegate.resetWriterIndex();
        return this;
    }

    public ByteBuf discardReadBytes() {
        this.delegate.discardReadBytes();
        return this;
    }

    public ByteBuf discardSomeReadBytes() {
        this.delegate.discardSomeReadBytes();
        return this;
    }

    public ByteBuf ensureWritable(int minWritableBytes) {
        this.delegate.ensureWritable(minWritableBytes);
        return this;
    }

    public int ensureWritable(int minWritableBytes, boolean force) {
        return this.delegate.ensureWritable(minWritableBytes, force);
    }

    public boolean getBoolean(int index) {
        return this.delegate.getBoolean(index);
    }

    public byte getByte(int index) {
        return this.delegate.getByte(index);
    }

    public short getUnsignedByte(int index) {
        return this.delegate.getUnsignedByte(index);
    }

    public short getShort(int index) {
        return this.delegate.getShort(index);
    }

    public short getShortLE(int index) {
        return this.delegate.getShortLE(index);
    }

    public int getUnsignedShort(int index) {
        return this.delegate.getUnsignedShort(index);
    }

    public int getUnsignedShortLE(int index) {
        return this.delegate.getUnsignedShortLE(index);
    }

    public int getMedium(int index) {
        return this.delegate.getMedium(index);
    }

    public int getMediumLE(int index) {
        return this.delegate.getMediumLE(index);
    }

    public int getUnsignedMedium(int index) {
        return this.delegate.getUnsignedMedium(index);
    }

    public int getUnsignedMediumLE(int index) {
        return this.delegate.getUnsignedMediumLE(index);
    }

    public int getInt(int index) {
        return this.delegate.getInt(index);
    }

    public int getIntLE(int index) {
        return this.delegate.getIntLE(index);
    }

    public long getUnsignedInt(int index) {
        return this.delegate.getUnsignedInt(index);
    }

    public long getUnsignedIntLE(int index) {
        return this.delegate.getUnsignedIntLE(index);
    }

    public long getLong(int index) {
        return this.delegate.getLong(index);
    }

    public long getLongLE(int index) {
        return this.delegate.getLongLE(index);
    }

    public char getChar(int index) {
        return this.delegate.getChar(index);
    }

    public float getFloat(int index) {
        return this.delegate.getFloat(index);
    }

    public float getFloatLE(int index) {
        return this.delegate.getFloatLE(index);
    }

    public double getDouble(int index) {
        return this.delegate.getDouble(index);
    }

    public double getDoubleLE(int index) {
        return this.delegate.getDoubleLE(index);
    }

    public ByteBuf getBytes(int index, ByteBuf dst) {
        this.delegate.getBytes(index, dst);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int length) {
        this.delegate.getBytes(index, dst, length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.delegate.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst) {
        this.delegate.getBytes(index, dst);
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.delegate.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.delegate.getBytes(index, dst);
        return this;
    }

    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.delegate.getBytes(index, out, length);
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.delegate.getBytes(index, out, length);
    }

    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        return this.delegate.getBytes(index, out, position, length);
    }

    public CharSequence getCharSequence(int index, int length, Charset charset) {
        return this.delegate.getCharSequence(index, length, charset);
    }

    public ByteBuf setBoolean(int index, boolean value) {
        this.delegate.setBoolean(index, value);
        return this;
    }

    public ByteBuf setByte(int index, int value) {
        this.delegate.setByte(index, value);
        return this;
    }

    public ByteBuf setShort(int index, int value) {
        this.delegate.setShort(index, value);
        return this;
    }

    public ByteBuf setShortLE(int index, int value) {
        this.delegate.setShortLE(index, value);
        return this;
    }

    public ByteBuf setMedium(int index, int value) {
        this.delegate.setMedium(index, value);
        return this;
    }

    public ByteBuf setMediumLE(int index, int value) {
        this.delegate.setMediumLE(index, value);
        return this;
    }

    public ByteBuf setInt(int index, int value) {
        this.delegate.setInt(index, value);
        return this;
    }

    public ByteBuf setIntLE(int index, int value) {
        this.delegate.setIntLE(index, value);
        return this;
    }

    public ByteBuf setLong(int index, long value) {
        this.delegate.setLong(index, value);
        return this;
    }

    public ByteBuf setLongLE(int index, long value) {
        this.delegate.setLongLE(index, value);
        return this;
    }

    public ByteBuf setChar(int index, int value) {
        this.delegate.setChar(index, value);
        return this;
    }

    public ByteBuf setFloat(int index, float value) {
        this.delegate.setFloat(index, value);
        return this;
    }

    public ByteBuf setFloatLE(int index, float value) {
        this.delegate.setFloatLE(index, value);
        return this;
    }

    public ByteBuf setDouble(int index, double value) {
        this.delegate.setDouble(index, value);
        return this;
    }

    public ByteBuf setDoubleLE(int index, double value) {
        this.delegate.setDoubleLE(index, value);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuf src) {
        this.delegate.setBytes(index, src);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuf src, int length) {
        this.delegate.setBytes(index, src, length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.delegate.setBytes(index, src, srcIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, byte[] src) {
        this.delegate.setBytes(index, src);
        return this;
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.delegate.setBytes(index, src, srcIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.delegate.setBytes(index, src);
        return this;
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.delegate.setBytes(index, in, length);
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.delegate.setBytes(index, in, length);
    }

    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        return this.delegate.setBytes(index, in, position, length);
    }

    public ByteBuf setZero(int index, int length) {
        this.delegate.setZero(index, length);
        return this;
    }

    public int setCharSequence(int index, CharSequence sequence, Charset charset) {
        return this.delegate.setCharSequence(index, sequence, charset);
    }

    public boolean readBoolean() {
        return this.delegate.readBoolean();
    }

    public byte readByte() {
        return this.delegate.readByte();
    }

    public short readUnsignedByte() {
        return this.delegate.readUnsignedByte();
    }

    public short readShort() {
        return this.delegate.readShort();
    }

    public short readShortLE() {
        return this.delegate.readShortLE();
    }

    public int readUnsignedShort() {
        return this.delegate.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.delegate.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.delegate.readMedium();
    }

    public int readMediumLE() {
        return this.delegate.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.delegate.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.delegate.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.delegate.readInt();
    }

    public int readIntLE() {
        return this.delegate.readIntLE();
    }

    public long readUnsignedInt() {
        return this.delegate.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.delegate.readUnsignedIntLE();
    }

    public long readLong() {
        return this.delegate.readLong();
    }

    public long readLongLE() {
        return this.delegate.readLongLE();
    }

    public char readChar() {
        return this.delegate.readChar();
    }

    public float readFloat() {
        return this.delegate.readFloat();
    }

    public float readFloatLE() {
        return this.delegate.readFloatLE();
    }

    public double readDouble() {
        return this.delegate.readDouble();
    }

    public double readDoubleLE() {
        return this.delegate.readDoubleLE();
    }

    public ByteBuf readBytes(int length) {
        return this.delegate.readBytes(length);
    }

    public ByteBuf readSlice(int length) {
        return this.delegate.readSlice(length);
    }

    public ByteBuf readRetainedSlice(int length) {
        return this.delegate.readRetainedSlice(length);
    }

    public ByteBuf readBytes(ByteBuf dst) {
        this.delegate.readBytes(dst);
        return this;
    }

    public ByteBuf readBytes(ByteBuf dst, int length) {
        this.delegate.readBytes(dst, length);
        return this;
    }

    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        this.delegate.readBytes(dst, dstIndex, length);
        return this;
    }

    public ByteBuf readBytes(byte[] dst) {
        this.delegate.readBytes(dst);
        return this;
    }

    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.delegate.readBytes(dst, dstIndex, length);
        return this;
    }

    public ByteBuf readBytes(ByteBuffer dst) {
        this.delegate.readBytes(dst);
        return this;
    }

    public ByteBuf readBytes(OutputStream out, int length) throws IOException {
        this.delegate.readBytes(out, length);
        return this;
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        return this.delegate.readBytes(out, length);
    }

    public CharSequence readCharSequence(int length, Charset charset) {
        return this.delegate.readCharSequence(length, charset);
    }

    public int readBytes(FileChannel out, long position, int length) throws IOException {
        return this.delegate.readBytes(out, position, length);
    }

    public ByteBuf skipBytes(int length) {
        this.delegate.skipBytes(length);
        return this;
    }

    public ByteBuf writeBoolean(boolean value) {
        this.delegate.writeBoolean(value);
        return this;
    }

    public ByteBuf writeByte(int value) {
        this.delegate.writeByte(value);
        return this;
    }

    public ByteBuf writeShort(int value) {
        this.delegate.writeShort(value);
        return this;
    }

    public ByteBuf writeShortLE(int value) {
        this.delegate.writeShortLE(value);
        return this;
    }

    public ByteBuf writeMedium(int value) {
        this.delegate.writeMedium(value);
        return this;
    }

    public ByteBuf writeMediumLE(int value) {
        this.delegate.writeMediumLE(value);
        return this;
    }

    public ByteBuf writeInt(int value) {
        this.delegate.writeInt(value);
        return this;
    }

    public ByteBuf writeIntLE(int value) {
        this.delegate.writeIntLE(value);
        return this;
    }

    public ByteBuf writeLong(long value) {
        this.delegate.writeLong(value);
        return this;
    }

    public ByteBuf writeLongLE(long value) {
        this.delegate.writeLongLE(value);
        return this;
    }

    public ByteBuf writeChar(int value) {
        this.delegate.writeChar(value);
        return this;
    }

    public ByteBuf writeFloat(float value) {
        this.delegate.writeFloat(value);
        return this;
    }

    public ByteBuf writeFloatLE(float value) {
        this.delegate.writeFloatLE(value);
        return this;
    }

    public ByteBuf writeDouble(double value) {
        this.delegate.writeDouble(value);
        return this;
    }

    public ByteBuf writeDoubleLE(double value) {
        this.delegate.writeDoubleLE(value);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf src) {
        this.delegate.writeBytes(src);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf src, int length) {
        this.delegate.writeBytes(src, length);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        this.delegate.writeBytes(src, srcIndex, length);
        return this;
    }

    public ByteBuf writeBytes(byte[] src) {
        this.delegate.writeBytes(src);
        return this;
    }

    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        this.delegate.writeBytes(src, srcIndex, length);
        return this;
    }

    public ByteBuf writeBytes(ByteBuffer src) {
        this.delegate.writeBytes(src);
        return this;
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        return this.delegate.writeBytes(in, length);
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        return this.delegate.writeBytes(in, length);
    }

    public int writeBytes(FileChannel in, long position, int length) throws IOException {
        return this.delegate.writeBytes(in, position, length);
    }

    public ByteBuf writeZero(int length) {
        this.delegate.writeZero(length);
        return this;
    }

    public int writeCharSequence(CharSequence sequence, Charset charset) {
        return this.delegate.writeCharSequence(sequence, charset);
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        return this.delegate.indexOf(fromIndex, toIndex, value);
    }

    public int bytesBefore(byte value) {
        return this.delegate.bytesBefore(value);
    }

    public int bytesBefore(int length, byte value) {
        return this.delegate.bytesBefore(length, value);
    }

    public int bytesBefore(int index, int length, byte value) {
        return this.delegate.bytesBefore(index, length, value);
    }

    public int forEachByte(ByteProcessor processor) {
        return this.delegate.forEachByte(processor);
    }

    public int forEachByte(int index, int length, ByteProcessor processor) {
        return this.delegate.forEachByte(index, length, processor);
    }

    public int forEachByteDesc(ByteProcessor processor) {
        return this.delegate.forEachByteDesc(processor);
    }

    public int forEachByteDesc(int index, int length, ByteProcessor processor) {
        return this.delegate.forEachByteDesc(index, length, processor);
    }

    public ByteBuf copy() {
        return this.delegate.copy();
    }

    public ByteBuf copy(int index, int length) {
        return this.delegate.copy(index, length);
    }

    public ByteBuf slice() {
        return this.wrap(this.delegate.slice());
    }

    public ByteBuf retainedSlice() {
        return this.wrap(this.delegate.retainedSlice());
    }

    public ByteBuf slice(int index, int length) {
        return this.wrap(this.delegate.slice(index, length));
    }

    public ByteBuf retainedSlice(int index, int length) {
        return this.wrap(this.delegate.retainedSlice(index, length));
    }

    public ByteBuf duplicate() {
        return this.wrap(this.delegate.duplicate());
    }

    public ByteBuf retainedDuplicate() {
        return this.wrap(this.delegate.retainedDuplicate());
    }

    public int nioBufferCount() {
        return this.delegate.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.delegate.nioBuffer();
    }

    public ByteBuffer nioBuffer(int index, int length) {
        return this.delegate.nioBuffer(index, length);
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        return this.delegate.internalNioBuffer(index, length);
    }

    public ByteBuffer[] nioBuffers() {
        return this.delegate.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        return this.delegate.nioBuffers(index, length);
    }

    public boolean hasArray() {
        return this.delegate.hasArray();
    }

    public byte[] array() {
        return this.delegate.array();
    }

    public int arrayOffset() {
        return this.delegate.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.delegate.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.delegate.memoryAddress();
    }

    public String toString(Charset charset) {
        return this.delegate.toString(charset);
    }

    public String toString(int index, int length, Charset charset) {
        return this.delegate.toString(index, length, charset);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int compareTo(ByteBuf buffer) {
        return this.delegate.compareTo(buffer);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public ByteBuf touch() {
        this.counted.touch();
        this.delegate.touch();
        return this;
    }

    public ByteBuf touch(Object hint) {
        this.counted.touch();
        this.delegate.touch(hint);
        return this;
    }

    protected class RefReferenceCounting
    extends AbstractReferenceCounted {
        protected RefReferenceCounting() {
        }

        protected void deallocate() {
            ByteBufRef.this.deallocate();
        }

        public ReferenceCounted touch(Object hint) {
            return this;
        }

        public void reset() {
            this.setRefCnt(1);
        }
    }
}

