/*
 * Decompiled with CFR 0.152.
 */
package ratpack.health;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ratpack.api.Nullable;
import ratpack.exec.Promise;
import ratpack.exec.Throttle;
import ratpack.exec.util.ParallelBatch;
import ratpack.func.Function;
import ratpack.health.HealthCheckResults;
import ratpack.registry.Registry;

public interface HealthCheck {
    public String getName();

    public Promise<Result> check(Registry var1) throws Exception;

    public static HealthCheck of(final String name, final Function<? super Registry, ? extends Promise<Result>> func) {
        return new HealthCheck(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Promise<Result> check(Registry registry) throws Exception {
                return (Promise)func.apply((Object)registry);
            }
        };
    }

    public static Promise<HealthCheckResults> checkAll(Registry registry, Iterable<? extends HealthCheck> healthChecks) {
        return HealthCheck.checkAll(registry, Throttle.unlimited(), healthChecks);
    }

    public static Promise<HealthCheckResults> checkAll(Registry registry, Throttle throttle, Iterable<? extends HealthCheck> healthChecks) {
        return Promise.flatten(() -> {
            ImmutableList healthChecksCopy = ImmutableList.copyOf((Iterable)healthChecks);
            if (healthChecksCopy.isEmpty()) {
                return Promise.value((Object)HealthCheckResults.empty());
            }
            Iterable resultPromises = Iterables.transform((Iterable)healthChecksCopy, h -> Promise.flatten(() -> h.check(registry)).throttled(throttle).mapError(Result::unhealthy).right(r -> h.getName()));
            ConcurrentHashMap results = new ConcurrentHashMap();
            return ParallelBatch.of((Iterable)resultPromises).forEach((i, result) -> results.put((String)result.right, (Result)result.left)).map(() -> new HealthCheckResults((ImmutableSortedMap<String, Result>)ImmutableSortedMap.copyOf((Map)results)));
        });
    }

    public static class Result {
        private static final Result HEALTHY = new Result(true, null, null);
        private final boolean healthy;
        private final String message;
        private final Throwable error;

        private Result(boolean healthy, String message, Throwable error) {
            this.healthy = healthy;
            this.message = message;
            this.error = error;
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        @Nullable
        public Throwable getError() {
            return this.error;
        }

        public static Result healthy() {
            return HEALTHY;
        }

        public static Result healthy(String message) {
            return new Result(true, message, null);
        }

        public static Result healthy(String message, Object ... args) {
            return Result.healthy(String.format(message, args));
        }

        public static Result unhealthy(String message) {
            return new Result(false, message, null);
        }

        public static Result unhealthy(String message, Object ... args) {
            return Result.unhealthy(String.format(message, args));
        }

        public static Result unhealthy(Throwable error) {
            return Result.unhealthy(error.getMessage(), error);
        }

        public static Result unhealthy(String message, Throwable error) {
            return new Result(false, message, error);
        }
    }
}

