/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http;

import io.netty.handler.codec.http.HttpResponseStatus;
import ratpack.http.internal.DefaultStatus;

public interface Status {
    public static final Status CONTINUE = Status.of(100);
    public static final Status SWITCHING_PROTOCOLS = Status.of(101);
    public static final Status PROCESSING = Status.of(102);
    public static final Status EARLY_HINTS = Status.of(103);
    public static final Status OK = Status.of(200);
    public static final Status CREATED = Status.of(201);
    public static final Status ACCEPTED = Status.of(202);
    public static final Status NON_AUTHORITATIVE_INFO = Status.of(203);
    public static final Status NO_CONTENT = Status.of(204);
    public static final Status RESET_CONTENT = Status.of(205);
    public static final Status PARTIAL_CONTENT = Status.of(206);
    public static final Status MULTI_STATUS = Status.of(207);
    public static final Status ALREADY_REPORTED = Status.of(208);
    public static final Status IM_USED = Status.of(226);
    public static final Status MULTIPLE_CHOICES = Status.of(300);
    public static final Status MOVED_PERMANENTLY = Status.of(301);
    public static final Status FOUND = Status.of(302);
    public static final Status SEE_OTHER = Status.of(303);
    public static final Status NOT_MODIFIED = Status.of(304);
    public static final Status USE_PROXY = Status.of(305);
    public static final Status TEMPORARY_REDIRECT = Status.of(307);
    public static final Status PERMANENT_REDIRECT = Status.of(308);
    public static final Status BAD_REQUEST = Status.of(400);
    public static final Status UNAUTHORIZED = Status.of(401);
    public static final Status PAYMENT_REQUIRED = Status.of(402);
    public static final Status FORBIDDEN = Status.of(403);
    public static final Status NOT_FOUND = Status.of(404);
    public static final Status METHOD_NOT_ALLOWED = Status.of(405);
    public static final Status NOT_ACCEPTABLE = Status.of(406);
    public static final Status PROXY_AUTH_REQUIRED = Status.of(407);
    public static final Status REQUEST_TIMEOUT = Status.of(408);
    public static final Status CONFLICT = Status.of(409);
    public static final Status GONE = Status.of(410);
    public static final Status LENGTH_REQUIRED = Status.of(411);
    public static final Status PRECONDITION_FAILED = Status.of(412);
    public static final Status PAYLOAD_TOO_LARGE = Status.of(413);
    public static final Status URI_TOO_LONG = Status.of(414);
    public static final Status UNSUPPORTED_MEDIA_TYPE = Status.of(415);
    public static final Status RANGE_NOT_SATISFIABLE = Status.of(416);
    public static final Status EXPECTATION_FAILED = Status.of(417);
    public static final Status IM_A_TEAPOT = Status.of(418);
    public static final Status MISDIRECTED_REQUEST = Status.of(421);
    public static final Status UNPROCESSABLE_ENTITY = Status.of(422);
    public static final Status LOCKED = Status.of(423);
    public static final Status FAILED_DEPENDENCY = Status.of(424);
    public static final Status UPGRADE_REQUIRED = Status.of(426);
    public static final Status PRECONDITION_REQUIRED = Status.of(428);
    public static final Status TOO_MANY_REQUESTS = Status.of(429);
    public static final Status HEADER_FIELDS_TOO_LARGE = Status.of(431);
    public static final Status UNAVAILBLE_FOR_LEGAL_REASONS = Status.of(451);
    public static final Status INTERNAL_SERVER_ERROR = Status.of(500);
    public static final Status NOT_IMPLEMENTED = Status.of(501);
    public static final Status BAD_GATEWAY = Status.of(502);
    public static final Status SERVICE_UNAVAILABLE = Status.of(503);
    public static final Status GATEWAY_TIMEOUT = Status.of(504);
    public static final Status HTTP_VER_NOT_SUPPORTED = Status.of(505);
    public static final Status VARIANT_ALSO_NEGOTIATES = Status.of(506);
    public static final Status INSUFFICIENT_STORAGE = Status.of(507);
    public static final Status LOOP_DETECTED = Status.of(508);
    public static final Status NOT_EXTENDED = Status.of(510);
    public static final Status NETWORK_AUTH_REQUIRED = Status.of(511);

    public static Status of(int code, String message) {
        return new DefaultStatus(new HttpResponseStatus(code, message));
    }

    public static Status of(int code) {
        return new DefaultStatus(HttpResponseStatus.valueOf((int)code));
    }

    public int getCode();

    public String getMessage();

    default public boolean is1xx() {
        return this.getCode() >= 100 && this.getCode() < 200;
    }

    default public boolean is2xx() {
        return this.getCode() >= 200 && this.getCode() < 300;
    }

    default public boolean is3xx() {
        return this.getCode() >= 300 && this.getCode() < 400;
    }

    default public boolean is4xx() {
        return this.getCode() >= 400 && this.getCode() < 500;
    }

    default public boolean is5xx() {
        return this.getCode() >= 500 && this.getCode() < 600;
    }

    public HttpResponseStatus getNettyStatus();
}

