/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.buffer.ByteBufAllocator;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import java.time.Duration;
import java.util.function.Supplier;
import ratpack.exec.ExecController;
import ratpack.exec.Operation;
import ratpack.func.Action;
import ratpack.http.client.HttpClient;
import ratpack.http.client.HttpClientSpec;
import ratpack.http.client.HttpResponse;
import ratpack.http.client.ProxySpec;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.DefaultHttpClient;
import ratpack.http.client.internal.DefaultProxy;
import ratpack.http.client.internal.ProxyInternal;
import ratpack.util.Exceptions;
import ratpack.util.internal.TransportDetector;

public class HttpClientBuilder
implements HttpClientSpec {
    private ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
    private int poolSize;
    private int poolQueueSize = Integer.MAX_VALUE;
    private Duration idleTimeout = Duration.ofSeconds(0L);
    private int maxContentLength = 0x100000;
    private int responseMaxChunkSize = 8192;
    private Duration readTimeout = Duration.ofSeconds(30L);
    private Duration connectTimeout = Duration.ofSeconds(30L);
    private Action<? super RequestSpec> requestInterceptor = Action.noop();
    private Action<? super HttpResponse> responseInterceptor = Action.noop();
    private Action<? super Throwable> errorInterceptor = Action.noop();
    private boolean enableMetricsCollection;
    private ProxyInternal proxy;
    private Supplier<AddressResolverGroup<?>> resolver = this.addressResolverSupplier((Action<? super DnsNameResolverBuilder>)Action.noop());
    private ExecController execController;

    public HttpClientBuilder() {
    }

    HttpClientBuilder(DefaultHttpClient builder) {
        this.byteBufAllocator = builder.byteBufAllocator;
        this.poolSize = builder.poolSize;
        this.poolQueueSize = builder.poolQueueSize;
        this.idleTimeout = builder.idleTimeout;
        this.maxContentLength = builder.maxContentLength;
        this.responseMaxChunkSize = builder.responseMaxChunkSize;
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.requestInterceptor = builder.requestInterceptor;
        this.responseInterceptor = builder.responseInterceptor;
        this.enableMetricsCollection = builder.enableMetricsCollection;
        this.proxy = builder.proxy;
        this.resolver = () -> builder.resolver;
    }

    @Override
    public HttpClientSpec execController(ExecController execController) {
        this.execController = execController;
        return this;
    }

    @Override
    public HttpClientSpec poolSize(int poolSize) {
        this.poolSize = poolSize;
        return this;
    }

    @Override
    public HttpClientSpec poolQueueSize(int poolQueueSize) {
        this.poolQueueSize = poolQueueSize;
        return this;
    }

    @Override
    public HttpClientSpec idleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    @Override
    public HttpClientSpec byteBufAllocator(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
        return this;
    }

    @Override
    public HttpClientSpec maxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    @Override
    public HttpClientSpec responseMaxChunkSize(int numBytes) {
        this.responseMaxChunkSize = numBytes;
        return this;
    }

    @Override
    public HttpClientSpec readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public HttpClientSpec connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public HttpClientSpec requestIntercept(Action<? super RequestSpec> interceptor) {
        this.requestInterceptor = this.requestInterceptor.append(interceptor);
        return this;
    }

    @Override
    public HttpClientSpec responseIntercept(Action<? super HttpResponse> interceptor) {
        this.responseInterceptor = this.responseInterceptor.append(interceptor);
        return this;
    }

    @Override
    public HttpClientSpec responseIntercept(Operation operation) {
        this.responseInterceptor = this.responseInterceptor.append(response -> operation.then());
        return this;
    }

    @Override
    public HttpClientSpec errorIntercept(Action<? super Throwable> interceptor) {
        this.errorInterceptor = this.errorInterceptor.append(interceptor);
        return this;
    }

    @Override
    public HttpClientSpec enableMetricsCollection(boolean enableMetricsCollection) {
        this.enableMetricsCollection = enableMetricsCollection;
        return this;
    }

    @Override
    public HttpClientSpec proxy(Action<? super ProxySpec> proxy) {
        DefaultProxy.Builder builder = new DefaultProxy.Builder();
        Exceptions.uncheck(() -> proxy.execute((Object)builder));
        this.proxy = builder.build();
        return this;
    }

    @Override
    public HttpClientSpec addressResolver(AddressResolverGroup<?> resolver) {
        this.resolver = () -> resolver;
        return this;
    }

    @Override
    public HttpClientSpec addressResolver(Action<? super DnsNameResolverBuilder> a) {
        this.resolver = this.addressResolverSupplier(a);
        return this;
    }

    public HttpClient build() {
        return new DefaultHttpClient(this.byteBufAllocator, this.poolSize, this.poolQueueSize, this.idleTimeout, this.maxContentLength, this.responseMaxChunkSize, this.readTimeout, this.connectTimeout, this.requestInterceptor, this.responseInterceptor, this.errorInterceptor, this.enableMetricsCollection, this.resolver.get(), this.proxy);
    }

    private Supplier<AddressResolverGroup<?>> addressResolverSupplier(Action<? super DnsNameResolverBuilder> spec) {
        return () -> {
            ExecController execController = this.execController;
            if (execController == null) {
                execController = (ExecController)ExecController.current().orElseThrow(() -> new IllegalStateException("Cannot build addressResolver as HttpClient is built on non managed thread, and execController not specified. Use HttpClientSpec.execController() or useJdkAddressResolver()."));
            }
            DnsNameResolverBuilder resolverBuilder = new DnsNameResolverBuilder().eventLoop(execController.getEventLoopGroup().next()).channelType(TransportDetector.getDatagramChannelImpl()).socketChannelType(TransportDetector.getSocketChannelImpl());
            Exceptions.uncheck(() -> spec.execute((Object)resolverBuilder));
            return new DnsAddressResolverGroup(resolverBuilder);
        };
    }
}

