/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.reflect.TypeToken;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.Optional;
import ratpack.exec.Blocking;
import ratpack.file.MimeTypes;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.handling.Context;
import ratpack.http.Response;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.render.Renderer;
import ratpack.render.RendererSupport;
import ratpack.util.Exceptions;
import ratpack.util.Types;

public class FileRenderer
extends RendererSupport<Path> {
    private final boolean cacheMetadata;
    public static final TypeToken<Renderer<Path>> TYPE = Types.intern((TypeToken)new TypeToken<Renderer<Path>>(){});
    public static final Renderer<Path> CACHING = new FileRenderer(true);
    public static final Renderer<Path> NON_CACHING = new FileRenderer(false);
    private static final Cache<Path, Optional<BasicFileAttributes>> CACHE = Caffeine.newBuilder().maximumSize(10000L).build();

    private FileRenderer(boolean cacheMetadata) {
        this.cacheMetadata = cacheMetadata;
    }

    @Override
    public void render(Context ctx, Path targetFile) throws Exception {
        FileRenderer.readAttributes(targetFile, this.cacheMetadata, (Action<? super BasicFileAttributes>)((Action)attributes -> {
            if (attributes == null || !attributes.isRegularFile()) {
                ctx.clientError(404);
            } else {
                FileRenderer.sendFile(ctx, targetFile, attributes);
            }
        }));
    }

    public static void sendFile(Context context, Path file, BasicFileAttributes attributes) {
        Date date = new Date(attributes.lastModifiedTime().toMillis());
        context.lastModified(date, () -> {
            String ifNoneMatch = context.getRequest().getHeaders().get((CharSequence)HttpHeaderNames.IF_NONE_MATCH);
            Response response = context.getResponse();
            if (ifNoneMatch != null && ifNoneMatch.trim().equals("*")) {
                response.status(HttpResponseStatus.NOT_MODIFIED.code()).send();
                return;
            }
            response.contentTypeIfNotSet(() -> ((MimeTypes)context.get(MimeTypes.class)).getContentType(file.getFileName().toString()));
            response.getHeaders().set(HttpHeaderConstants.CONTENT_LENGTH, Long.toString(attributes.size()));
            try {
                response.sendFile(file);
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        });
    }

    private static Factory<BasicFileAttributes> getter(Path file) {
        return () -> {
            if (Files.exists(file, new LinkOption[0])) {
                return Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            }
            return null;
        };
    }

    public static void readAttributes(Path file, boolean cacheMetadata, Action<? super BasicFileAttributes> then) throws Exception {
        if (cacheMetadata) {
            Optional basicFileAttributes = (Optional)CACHE.getIfPresent((Object)file);
            if (basicFileAttributes == null) {
                Blocking.get(FileRenderer.getter(file)).then(a -> {
                    CACHE.put((Object)file, Optional.ofNullable(a));
                    then.execute(a);
                });
            } else {
                then.execute(basicFileAttributes.orElse(null));
            }
        } else {
            Blocking.get(FileRenderer.getter(file)).then(then);
        }
    }
}

