/*
 * Decompiled with CFR 0.152.
 */
package ratpack.health.internal;

import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import ratpack.handling.Context;
import ratpack.health.HealthCheckResults;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.render.Renderer;
import ratpack.render.RendererSupport;
import ratpack.util.Types;

public class HealthCheckResultsRenderer
extends RendererSupport<HealthCheckResults> {
    public static final TypeToken<Renderer<HealthCheckResults>> TYPE = Types.intern((TypeToken)new TypeToken<Renderer<HealthCheckResults>>(){});
    private final ByteBufAllocator byteBufAllocator;

    public HealthCheckResultsRenderer(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
    }

    @Override
    public void render(Context ctx, HealthCheckResults healthCheckResults) throws Exception {
        ByteBuf buffer = this.byteBufAllocator.buffer();
        try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream((OutputStream)new ByteBufOutputStream(buffer)));){
            healthCheckResults.writeTo(writer);
        }
        catch (Exception e) {
            buffer.release();
            throw e;
        }
        ctx.getResponse().contentTypeIfNotSet(HttpHeaderConstants.PLAIN_TEXT_UTF8).status(healthCheckResults.isUnhealthy() ? 503 : 200).send(buffer);
    }
}

