/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import java.net.URI;
import java.time.Duration;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.exec.internal.ExecControllerInternal;
import ratpack.func.Action;
import ratpack.http.client.HttpClient;
import ratpack.http.client.HttpClientSpec;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.StreamedResponse;
import ratpack.http.client.internal.ContentAggregatingRequestAction;
import ratpack.http.client.internal.ContentStreamingRequestAction;
import ratpack.http.client.internal.HttpChannelKey;
import ratpack.http.client.internal.HttpChannelPoolMap;
import ratpack.http.client.internal.HttpClientInternal;
import ratpack.http.client.internal.IdlingConnectionHandler;
import ratpack.util.internal.ChannelImplDetector;

public class DefaultHttpClient
implements HttpClientInternal {
    private static final ChannelHealthChecker ALWAYS_UNHEALTHY = channel -> channel.eventLoop().newSucceededFuture((Object)Boolean.FALSE);
    private static final ChannelPoolHandler NOOP_HANDLER = new AbstractChannelPoolHandler(){

        public void channelCreated(Channel ch) throws Exception {
        }

        public void channelReleased(Channel ch) throws Exception {
        }
    };
    private static final ChannelPoolHandler POOLING_HANDLER = new AbstractChannelPoolHandler(){

        public void channelCreated(Channel ch) throws Exception {
        }

        public void channelReleased(Channel ch) throws Exception {
            if (ch.isOpen()) {
                ch.config().setAutoRead(true);
                ch.pipeline().addLast(new ChannelHandler[]{IdlingConnectionHandler.INSTANCE});
            }
        }

        public void channelAcquired(Channel ch) throws Exception {
            ch.pipeline().remove((ChannelHandler)IdlingConnectionHandler.INSTANCE);
        }
    };
    private final HttpChannelPoolMap channelPoolMap = new HttpChannelPoolMap(){

        protected ChannelPool newPool(HttpChannelKey key) {
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress(key.host, key.port).group((EventLoopGroup)key.execution.getEventLoop())).channel(ChannelImplDetector.getSocketChannelImpl())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)key.connectTimeout.toMillis()))).option(ChannelOption.ALLOCATOR, (Object)DefaultHttpClient.this.byteBufAllocator)).option(ChannelOption.AUTO_READ, (Object)false)).option(ChannelOption.SO_KEEPALIVE, (Object)DefaultHttpClient.this.isPooling());
            if (DefaultHttpClient.this.isPooling()) {
                FixedChannelPool channelPool = new FixedChannelPool(bootstrap, POOLING_HANDLER, DefaultHttpClient.this.getPoolSize());
                ((ExecControllerInternal)key.execution.getController()).onClose(() -> this.lambda$newPool$0(key, (ChannelPool)channelPool));
                return channelPool;
            }
            return new SimpleChannelPool(bootstrap, NOOP_HANDLER, ALWAYS_UNHEALTHY);
        }

        private /* synthetic */ void lambda$newPool$0(HttpChannelKey key, ChannelPool channelPool) throws Exception {
            this.remove(key);
            channelPool.close();
        }
    };
    private final ByteBufAllocator byteBufAllocator;
    private final int maxContentLength;
    private final int maxResponseChunkSize;
    private final int poolSize;
    private final Duration readTimeout;
    private final Duration connectTimeout;

    private DefaultHttpClient(ByteBufAllocator byteBufAllocator, int maxContentLength, int maxResponseChunkSize, int poolSize, Duration readTimeout, Duration connectTimeout) {
        this.byteBufAllocator = byteBufAllocator;
        this.maxContentLength = maxContentLength;
        this.maxResponseChunkSize = maxResponseChunkSize;
        this.poolSize = poolSize;
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getPoolSize() {
        return this.poolSize;
    }

    private boolean isPooling() {
        return this.getPoolSize() > 0;
    }

    @Override
    public HttpChannelPoolMap getChannelPoolMap() {
        return this.channelPoolMap;
    }

    @Override
    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    @Override
    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    @Override
    public int getMaxResponseChunkSize() {
        return this.maxResponseChunkSize;
    }

    @Override
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void close() {
        this.channelPoolMap.close();
    }

    public static HttpClient of(Action<? super HttpClientSpec> action) throws Exception {
        Spec spec = new Spec();
        action.execute((Object)spec);
        return new DefaultHttpClient(spec.byteBufAllocator, spec.maxContentLength, spec.responseMaxChunkSize, spec.poolSize, spec.readTimeout, spec.connectTimeout);
    }

    @Override
    public Promise<ReceivedResponse> get(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, action);
    }

    @Override
    public Promise<ReceivedResponse> post(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, (Action<? super RequestSpec>)action.prepend(RequestSpec::post));
    }

    @Override
    public Promise<ReceivedResponse> request(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return Promise.async(downstream -> new ContentAggregatingRequestAction(uri, this, 0, Execution.current(), requestConfigurer).connect(downstream));
    }

    @Override
    public Promise<StreamedResponse> requestStream(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return Promise.async(downstream -> new ContentStreamingRequestAction(uri, this, 0, Execution.current(), requestConfigurer).connect(downstream));
    }

    private static class Spec
    implements HttpClientSpec {
        private ByteBufAllocator byteBufAllocator = PooledByteBufAllocator.DEFAULT;
        private int poolSize;
        private int maxContentLength = 0x100000;
        private int responseMaxChunkSize = 8192;
        private Duration readTimeout = Duration.ofSeconds(30L);
        private Duration connectTimeout = Duration.ofSeconds(30L);

        private Spec() {
        }

        @Override
        public HttpClientSpec poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        @Override
        public HttpClientSpec byteBufAllocator(ByteBufAllocator byteBufAllocator) {
            this.byteBufAllocator = byteBufAllocator;
            return this;
        }

        @Override
        public HttpClientSpec maxContentLength(int maxContentLength) {
            this.maxContentLength = maxContentLength;
            return this;
        }

        @Override
        public HttpClientSpec responseMaxChunkSize(int numBytes) {
            this.responseMaxChunkSize = numBytes;
            return this;
        }

        @Override
        public HttpClientSpec readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public HttpClientSpec connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }
    }
}

