/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.handler.ssl.SslContext;
import java.net.URI;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.func.Function;
import ratpack.http.HttpMethod;
import ratpack.http.MutableHeaders;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;

public class DelegatingRequestSpec
implements RequestSpec {
    private final RequestSpec delegate;

    public DelegatingRequestSpec(RequestSpec delegate) {
        this.delegate = delegate;
    }

    protected RequestSpec getDelegate() {
        return this.delegate;
    }

    @Override
    public RequestSpec redirects(int maxRedirects) {
        this.delegate.redirects(maxRedirects);
        return this;
    }

    @Override
    public RequestSpec onRedirect(Function<? super ReceivedResponse, Action<? super RequestSpec>> function) {
        this.delegate.onRedirect(function);
        return this;
    }

    @Override
    public RequestSpec sslContext(SSLContext sslContext) {
        this.delegate.sslContext(sslContext);
        return this;
    }

    @Override
    public RequestSpec sslContext(Factory<SSLContext> factory) throws Exception {
        this.delegate.sslContext(factory);
        return this;
    }

    @Override
    public RequestSpec sslContext(SslContext sslContext) {
        this.delegate.sslContext(sslContext);
        return this;
    }

    @Override
    public MutableHeaders getHeaders() {
        return this.delegate.getHeaders();
    }

    @Override
    public RequestSpec headers(Action<? super MutableHeaders> action) throws Exception {
        this.delegate.headers(action);
        return this;
    }

    @Override
    public RequestSpec method(HttpMethod method) {
        this.delegate.method(method);
        return this;
    }

    @Override
    public RequestSpec decompressResponse(boolean shouldDecompress) {
        this.delegate.decompressResponse(shouldDecompress);
        return this;
    }

    @Override
    public URI getUri() {
        return this.delegate.getUri();
    }

    @Override
    public RequestSpec connectTimeout(Duration duration) {
        this.delegate.connectTimeout(duration);
        return this;
    }

    @Override
    public RequestSpec readTimeout(Duration duration) {
        this.delegate.readTimeout(duration);
        return this;
    }

    @Override
    public RequestSpec.Body getBody() {
        return this.delegate.getBody();
    }

    @Override
    public RequestSpec body(Action<? super RequestSpec.Body> action) throws Exception {
        this.delegate.body(action);
        return this;
    }

    @Override
    public RequestSpec basicAuth(String username, String password) {
        this.delegate.basicAuth(username, password);
        return this;
    }

    @Override
    public RequestSpec maxContentLength(int numBytes) {
        return this.delegate.maxContentLength(numBytes);
    }

    @Override
    public RequestSpec responseMaxChunkSize(int numBytes) {
        this.delegate.responseMaxChunkSize(numBytes);
        return this;
    }
}

