/*
 * Decompiled with CFR 0.152.
 */
package ratpack.ssl.internal;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class SslContexts {
    public static KeyManagerFactory keyManagerFactory(InputStream keyStoreStream, char[] keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(keyStoreStream, keyStorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(SslContexts.getAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword);
        return keyManagerFactory;
    }

    public static TrustManagerFactory trustManagerFactory(InputStream trustStoreStream, char[] trustStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(trustStoreStream, trustStorePassword);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(SslContexts.getAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory;
    }

    private static String getAlgorithm() {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        return algorithm;
    }

    private SslContexts() {
    }
}

