/*
 * Decompiled with CFR 0.152.
 */
package ratpack.render.internal;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import ratpack.exec.Promise;
import ratpack.handling.Context;
import ratpack.render.NoSuchRendererException;
import ratpack.render.RenderException;
import ratpack.render.RenderableDecorator;
import ratpack.render.Renderer;
import ratpack.render.RendererException;
import ratpack.render.internal.RenderController;
import ratpack.util.Types;

public class DefaultRenderController
implements RenderController {
    private static final TypeToken<Renderer<?>> RENDERER_TYPE = Types.intern((TypeToken)new TypeToken<Renderer<?>>(){});
    private static final TypeToken<RenderableDecorator<?>> RENDERABLE_DECORATOR_TYPE = Types.intern((TypeToken)new TypeToken<RenderableDecorator<?>>(){});

    @Override
    public void render(Object toRender, Context context) throws Exception {
        if (toRender == null) {
            context.clientError(404);
            return;
        }
        this.doRender(toRender, context);
    }

    private <T> void doRender(T toRender, Context context) throws Exception {
        Class type = (Class)Types.cast(toRender.getClass());
        Iterator decorators = Iterables.filter((Iterable)context.getAll(RENDERABLE_DECORATOR_TYPE), d -> d.getType().isAssignableFrom(type)).iterator();
        if (decorators.hasNext()) {
            Promise promise = Promise.value(toRender);
            while (decorators.hasNext()) {
                RenderableDecorator cast = (RenderableDecorator)Types.cast(decorators.next());
                promise = promise.flatMap(r -> cast.decorate(context, r));
            }
            promise.then(r -> this.doRender(context, type, r));
        } else {
            this.doRender(context, type, toRender);
        }
    }

    private <T> void doRender(Context context, Class<T> type, T decorated) {
        Iterable renderers = context.getAll(RENDERER_TYPE);
        for (Renderer renderer : renderers) {
            if (!renderer.getType().isAssignableFrom(type)) continue;
            Renderer cast = (Renderer)Types.cast((Object)renderer);
            try {
                cast.render(context, decorated);
                return;
            }
            catch (RenderException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RendererException(renderer, decorated, e);
            }
        }
        throw new NoSuchRendererException(decorated);
    }
}

