/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.handling.internal;

import io.netty.handler.codec.http.HttpResponseStatus;
import ratpack.core.handling.Context;
import ratpack.core.handling.Handler;

public class ContentTypeHandler
implements Handler {
    private final String[] contentTypes;

    public ContentTypeHandler(String ... contentTypes) {
        this.contentTypes = contentTypes;
    }

    @Override
    public void handle(Context context) throws Exception {
        boolean accepted = false;
        String requestType = context.getRequest().getContentType().getType();
        if (requestType != null) {
            for (String contentType : this.contentTypes) {
                if (!requestType.equals(contentType)) continue;
                accepted = true;
                break;
            }
        }
        if (accepted) {
            context.next();
        } else {
            context.clientError(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE.code());
        }
    }
}

