/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.handling.internal;

import ratpack.core.handling.Context;
import ratpack.core.handling.Handler;
import ratpack.core.http.HttpMethod;
import ratpack.core.http.Response;
import ratpack.core.http.internal.DefaultHttpMethod;
import ratpack.core.http.internal.HttpHeaderConstants;

public class MethodHandler
implements Handler {
    private final HttpMethod method;
    public static final Handler GET = new MethodHandler("GET");
    public static final Handler POST = new MethodHandler("POST");
    public static final Handler PUT = new MethodHandler("PUT");
    public static final Handler PATCH = new MethodHandler("PATCH");
    public static final Handler DELETE = new MethodHandler("DELETE");
    public static final Handler OPTIONS = new MethodHandler("OPTIONS");

    private MethodHandler(String method) {
        this.method = DefaultHttpMethod.valueOf(io.netty.handler.codec.http.HttpMethod.valueOf((String)method));
    }

    @Override
    public void handle(Context context) {
        HttpMethod requestMethod = context.getRequest().getMethod();
        if (requestMethod == this.method || requestMethod.name(this.method.getName())) {
            context.next();
        } else if (requestMethod.isOptions()) {
            Response response = context.getResponse();
            response.getHeaders().add(HttpHeaderConstants.ALLOW, this.method);
            response.status(200).send();
        } else {
            context.clientError(405);
        }
    }
}

