/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.health;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Optional;
import ratpack.core.handling.Context;
import ratpack.core.handling.Handler;
import ratpack.core.health.HealthCheck;
import ratpack.exec.Throttle;
import ratpack.func.Types;

public class HealthCheckHandler
implements Handler {
    public static final String DEFAULT_NAME_TOKEN = "name";
    private static final TypeToken<HealthCheck> HEALTH_CHECK_TYPE_TOKEN = Types.token(HealthCheck.class);
    private final String name;
    private final Throttle throttle;

    public HealthCheckHandler() {
        this(DEFAULT_NAME_TOKEN, Throttle.unlimited());
    }

    public HealthCheckHandler(String pathTokenName) {
        this(pathTokenName, Throttle.unlimited());
    }

    public HealthCheckHandler(Throttle throttle) {
        this(DEFAULT_NAME_TOKEN, throttle);
    }

    protected HealthCheckHandler(String pathTokenName, Throttle throttle) {
        this.name = pathTokenName;
        this.throttle = throttle;
    }

    public Throttle getThrottle() {
        return this.throttle;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void handle(Context ctx) throws Exception {
        ctx.getResponse().getHeaders().add("Cache-Control", "no-cache, no-store, must-revalidate").add("Pragma", "no-cache").add("Expires", 0);
        String checkName = (String)ctx.getPathTokens().get(this.name);
        if (checkName != null) {
            Optional first = ctx.first(HEALTH_CHECK_TYPE_TOKEN, healthCheck -> healthCheck.getName().equals(checkName) ? healthCheck : null);
            if (first.isPresent()) {
                ctx.render(HealthCheck.checkAll(ctx, Collections.singleton((HealthCheck)first.get())));
            } else {
                ctx.clientError(404);
            }
        } else {
            ctx.render(HealthCheck.checkAll(ctx, this.throttle, ctx.getAll(HEALTH_CHECK_TYPE_TOKEN)));
        }
    }
}

