/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import ratpack.core.handling.Context;
import ratpack.core.http.Response;
import ratpack.core.http.internal.HttpHeaderConstants;
import ratpack.core.render.Renderable;
import ratpack.exec.stream.Streams;
import ratpack.func.Exceptions;
import ratpack.func.Function;

public class ResponseChunks
implements Renderable {
    private final Function<? super ByteBufAllocator, ? extends Publisher<? extends ByteBuf>> publisherFactory;
    private final CharSequence contentType;

    public static ResponseChunks stringChunks(Publisher<? extends CharSequence> publisher) {
        return ResponseChunks.stringChunks(HttpHeaderConstants.PLAIN_TEXT_UTF8, CharsetUtil.UTF_8, publisher);
    }

    public static ResponseChunks stringChunks(CharSequence contentType, Publisher<? extends CharSequence> publisher) {
        return ResponseChunks.stringChunks(contentType, CharsetUtil.UTF_8, publisher);
    }

    public static ResponseChunks stringChunks(CharSequence contentType, Charset charset, Publisher<? extends CharSequence> publisher) {
        return new ResponseChunks(contentType, (Function<? super ByteBufAllocator, ? extends Publisher<? extends ByteBuf>>)((Function)allocator -> Streams.map((Publisher)publisher, charSequence -> ByteBufUtil.encodeString((ByteBufAllocator)allocator, (CharBuffer)CharBuffer.wrap(charSequence), (Charset)charset))));
    }

    public static ResponseChunks bufferChunks(CharSequence contentType, Publisher<? extends ByteBuf> publisher) {
        return new ResponseChunks(contentType, (Function<? super ByteBufAllocator, ? extends Publisher<? extends ByteBuf>>)((Function)byteBufAllocator -> publisher));
    }

    private ResponseChunks(CharSequence contentType, Function<? super ByteBufAllocator, ? extends Publisher<? extends ByteBuf>> publisherFactory) {
        this.publisherFactory = publisherFactory;
        this.contentType = contentType;
    }

    public Publisher<? extends ByteBuf> publisher(ByteBufAllocator byteBufAllocator) {
        return (Publisher)Exceptions.uncheck(() -> (Publisher)this.publisherFactory.apply((Object)byteBufAllocator));
    }

    public CharSequence getContentType() {
        return this.contentType;
    }

    @Override
    public void render(Context context) throws Exception {
        Response response = context.getResponse();
        response.getHeaders().add(HttpHeaderConstants.TRANSFER_ENCODING, HttpHeaderConstants.CHUNKED);
        response.getHeaders().set(HttpHeaderConstants.CONTENT_TYPE, this.getContentType());
        Publisher<? extends ByteBuf> publisher = this.publisher((ByteBufAllocator)context.get(ByteBufAllocator.class));
        response.sendStream(publisher);
    }
}

