/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.client.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.resolver.AddressResolverGroup;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import ratpack.core.http.client.HttpClient;
import ratpack.core.http.client.HttpClientSpec;
import ratpack.core.http.client.HttpResponse;
import ratpack.core.http.client.Proxy;
import ratpack.core.http.client.ReceivedResponse;
import ratpack.core.http.client.RequestSpec;
import ratpack.core.http.client.StreamedResponse;
import ratpack.core.http.client.internal.ChannelPoolStats;
import ratpack.core.http.client.internal.CleanClosingFixedChannelPool;
import ratpack.core.http.client.internal.ContentAggregatingRequestAction;
import ratpack.core.http.client.internal.ContentStreamingRequestAction;
import ratpack.core.http.client.internal.HttpChannelKey;
import ratpack.core.http.client.internal.HttpChannelPoolMap;
import ratpack.core.http.client.internal.HttpClientBuilder;
import ratpack.core.http.client.internal.HttpClientInternal;
import ratpack.core.http.client.internal.HttpClientStats;
import ratpack.core.http.client.internal.InstrumentedChannelPoolHandler;
import ratpack.core.http.client.internal.InstrumentedFixedChannelPoolHandler;
import ratpack.core.http.client.internal.InstrumentedSimpleChannelPoolHandler;
import ratpack.core.http.client.internal.NoopFixedChannelPoolHandler;
import ratpack.core.http.client.internal.NoopSimpleChannelPoolHandler;
import ratpack.core.http.client.internal.ProxyInternal;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.exec.util.internal.TransportDetector;
import ratpack.func.Action;
import ratpack.func.Nullable;

public class DefaultHttpClient
implements HttpClientInternal {
    private static final ChannelHealthChecker ALWAYS_UNHEALTHY = channel -> channel.eventLoop().newSucceededFuture((Object)Boolean.FALSE);
    final ByteBufAllocator byteBufAllocator;
    final int poolSize;
    final int poolQueueSize;
    final Duration idleTimeout;
    final int maxContentLength;
    final int responseMaxChunkSize;
    final Duration readTimeout;
    final Duration connectTimeout;
    final Action<? super RequestSpec> requestInterceptor;
    final Action<? super HttpResponse> responseInterceptor;
    final Action<? super Throwable> errorInterceptor;
    final boolean enableMetricsCollection;
    final AddressResolverGroup<?> resolver;
    @Nullable
    final ProxyInternal proxy;
    private final Map<String, ChannelPoolStats> hostStats = new ConcurrentHashMap<String, ChannelPoolStats>();
    private final HttpChannelPoolMap channelPoolMap = new HttpChannelPoolMap(){

        protected ChannelPool newPool(HttpChannelKey key) {
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress(key.host, key.port).group((EventLoopGroup)key.execution.getEventLoop())).resolver(DefaultHttpClient.this.resolver).channel(TransportDetector.getSocketChannelImpl())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)key.connectTimeout.toMillis()))).option(ChannelOption.ALLOCATOR, (Object)DefaultHttpClient.this.byteBufAllocator)).option(ChannelOption.AUTO_READ, (Object)false)).option(ChannelOption.SO_KEEPALIVE, (Object)DefaultHttpClient.this.isPooling());
            if (DefaultHttpClient.this.isPooling()) {
                InstrumentedChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.getPoolingHandler(key);
                DefaultHttpClient.this.hostStats.put(key.host, channelPoolHandler);
                CleanClosingFixedChannelPool channelPool = new CleanClosingFixedChannelPool(bootstrap, channelPoolHandler, DefaultHttpClient.this.getPoolSize(), DefaultHttpClient.this.getPoolQueueSize());
                key.execution.getController().onClose(() -> {
                    this.remove(key);
                    channelPool.closeCleanly();
                });
                return channelPool;
            }
            InstrumentedChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.getSimpleHandler(key);
            DefaultHttpClient.this.hostStats.put(key.host, channelPoolHandler);
            return new SimpleChannelPool(bootstrap, (ChannelPoolHandler)channelPoolHandler, ALWAYS_UNHEALTHY);
        }
    };

    public DefaultHttpClient(ByteBufAllocator byteBufAllocator, int poolSize, int poolQueueSize, Duration idleTimeout, int maxContentLength, int responseMaxChunkSize, Duration readTimeout, Duration connectTimeout, Action<? super RequestSpec> requestInterceptor, Action<? super HttpResponse> responseInterceptor, Action<? super Throwable> errorInterceptor, boolean enableMetricsCollection, AddressResolverGroup<?> resolver, @Nullable ProxyInternal proxy) {
        this.byteBufAllocator = byteBufAllocator;
        this.poolSize = poolSize;
        this.poolQueueSize = poolQueueSize;
        this.idleTimeout = idleTimeout;
        this.maxContentLength = maxContentLength;
        this.responseMaxChunkSize = responseMaxChunkSize;
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.requestInterceptor = requestInterceptor;
        this.responseInterceptor = responseInterceptor;
        this.errorInterceptor = errorInterceptor;
        this.enableMetricsCollection = enableMetricsCollection;
        this.resolver = resolver;
        this.proxy = proxy;
    }

    private InstrumentedChannelPoolHandler getPoolingHandler(HttpChannelKey key) {
        if (this.enableMetricsCollection) {
            return new InstrumentedFixedChannelPoolHandler(key, this.getPoolSize(), this.getIdleTimeout(), this.proxy);
        }
        return new NoopFixedChannelPoolHandler(key, this.getIdleTimeout(), this.proxy);
    }

    private InstrumentedChannelPoolHandler getSimpleHandler(HttpChannelKey key) {
        if (this.enableMetricsCollection) {
            return new InstrumentedSimpleChannelPoolHandler(key, this.proxy);
        }
        return new NoopSimpleChannelPoolHandler(key, this.proxy);
    }

    @Override
    public int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public int getPoolQueueSize() {
        return this.poolQueueSize;
    }

    @Override
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    private boolean isPooling() {
        return this.getPoolSize() > 0;
    }

    @Override
    public HttpChannelPoolMap getChannelPoolMap() {
        return this.channelPoolMap;
    }

    @Override
    public Action<? super RequestSpec> getRequestInterceptor() {
        return this.requestInterceptor;
    }

    @Override
    public Action<? super HttpResponse> getResponseInterceptor() {
        return this.responseInterceptor;
    }

    @Override
    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    @Override
    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    @Override
    public int getMaxResponseChunkSize() {
        return this.responseMaxChunkSize;
    }

    @Override
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public void close() {
        this.channelPoolMap.close();
    }

    @Override
    public HttpClient copyWith(Action<? super HttpClientSpec> action) throws Exception {
        HttpClientBuilder builder = new HttpClientBuilder(this);
        action.execute((Object)builder);
        return builder.build();
    }

    @Override
    public Promise<ReceivedResponse> get(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, action);
    }

    @Override
    public Promise<ReceivedResponse> post(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, (Action<? super RequestSpec>)action.prepend(RequestSpec::post));
    }

    @Override
    public Promise<ReceivedResponse> request(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return this.intercept(Promise.async(downstream -> new ContentAggregatingRequestAction(uri, this, 0, false, Execution.current(), (Action<? super RequestSpec>)requestConfigurer.append(this.requestInterceptor)).connect(downstream)), this.responseInterceptor, this.errorInterceptor);
    }

    @Override
    public Promise<StreamedResponse> requestStream(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return this.intercept(Promise.async(downstream -> new ContentStreamingRequestAction(uri, this, 0, false, Execution.current(), (Action<? super RequestSpec>)requestConfigurer.append(this.requestInterceptor)).connect(downstream)), this.responseInterceptor, this.errorInterceptor);
    }

    private <T extends HttpResponse> Promise<T> intercept(Promise<T> promise, Action<? super HttpResponse> action, Action<? super Throwable> errorAction) {
        return promise.wiretap(r -> {
            if (r.isError()) {
                ExecController.require().fork().eventLoop(Execution.current().getEventLoop()).start(e -> errorAction.execute((Object)r.getThrowable()));
            }
        }).next(r -> ExecController.require().fork().eventLoop(Execution.current().getEventLoop()).start(e -> action.execute(r)));
    }

    public HttpClientStats getHttpClientStats() {
        return new HttpClientStats(this.hostStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ChannelPoolStats)e.getValue()).getHostStats())));
    }
}

