/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.client.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import ratpack.core.http.client.internal.HttpChannelKey;
import ratpack.core.http.client.internal.InstrumentedChannelPoolHandler;
import ratpack.core.http.client.internal.ProxyInternal;
import ratpack.func.Nullable;

public class NoopSimpleChannelPoolHandler
extends AbstractChannelPoolHandler
implements InstrumentedChannelPoolHandler {
    private final String host;
    @Nullable
    private final ProxyInternal proxy;

    public NoopSimpleChannelPoolHandler(HttpChannelKey channelKey, @Nullable ProxyInternal proxy) {
        this.host = channelKey.host;
        this.proxy = proxy;
    }

    public void channelCreated(Channel ch) {
        if (this.proxy != null && this.proxy.shouldProxy(this.host)) {
            InetSocketAddress proxyAddress = new InetSocketAddress(this.proxy.getHost(), this.proxy.getPort());
            ch.pipeline().addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyAddress)});
        }
    }

    public void channelReleased(Channel ch) throws Exception {
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getActiveConnectionCount() {
        return 0;
    }

    @Override
    public int getIdleConnectionCount() {
        return 0;
    }
}

