/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.internal;

import com.google.common.collect.ImmutableMap;
import java.util.IdentityHashMap;
import java.util.Map;
import ratpack.core.http.HttpMethod;

public class DefaultHttpMethod
implements HttpMethod {
    private final io.netty.handler.codec.http.HttpMethod nettyMethod;
    private static final Map<io.netty.handler.codec.http.HttpMethod, HttpMethod> METHODS = new IdentityHashMap<io.netty.handler.codec.http.HttpMethod, HttpMethod>((Map<io.netty.handler.codec.http.HttpMethod, HttpMethod>)ImmutableMap.builder().put((Object)io.netty.handler.codec.http.HttpMethod.GET, (Object)new DefaultHttpMethod(io.netty.handler.codec.http.HttpMethod.GET)).put((Object)io.netty.handler.codec.http.HttpMethod.HEAD, (Object)new DefaultHttpMethod(io.netty.handler.codec.http.HttpMethod.HEAD)).put((Object)io.netty.handler.codec.http.HttpMethod.POST, (Object)new DefaultHttpMethod(io.netty.handler.codec.http.HttpMethod.POST)).put((Object)io.netty.handler.codec.http.HttpMethod.PUT, (Object)new DefaultHttpMethod(io.netty.handler.codec.http.HttpMethod.PUT)).put((Object)io.netty.handler.codec.http.HttpMethod.DELETE, (Object)new DefaultHttpMethod(io.netty.handler.codec.http.HttpMethod.DELETE)).put((Object)io.netty.handler.codec.http.HttpMethod.OPTIONS, (Object)new DefaultHttpMethod(io.netty.handler.codec.http.HttpMethod.OPTIONS)).put((Object)io.netty.handler.codec.http.HttpMethod.PATCH, (Object)new DefaultHttpMethod(io.netty.handler.codec.http.HttpMethod.PATCH)).put((Object)io.netty.handler.codec.http.HttpMethod.TRACE, (Object)new DefaultHttpMethod(io.netty.handler.codec.http.HttpMethod.TRACE)).put((Object)io.netty.handler.codec.http.HttpMethod.CONNECT, (Object)new DefaultHttpMethod(io.netty.handler.codec.http.HttpMethod.CONNECT)).build());

    private DefaultHttpMethod(io.netty.handler.codec.http.HttpMethod nettyMethod) {
        this.nettyMethod = nettyMethod;
    }

    @Override
    public String getName() {
        return this.nettyMethod.name();
    }

    @Override
    public boolean isPost() {
        return this.nettyMethod == io.netty.handler.codec.http.HttpMethod.POST;
    }

    @Override
    public boolean isGet() {
        return this.nettyMethod == io.netty.handler.codec.http.HttpMethod.GET || this.nettyMethod == io.netty.handler.codec.http.HttpMethod.HEAD;
    }

    @Override
    public boolean isHead() {
        return this.nettyMethod == io.netty.handler.codec.http.HttpMethod.HEAD;
    }

    @Override
    public boolean isPut() {
        return this.nettyMethod == io.netty.handler.codec.http.HttpMethod.PUT;
    }

    @Override
    public boolean isPatch() {
        return this.nettyMethod == io.netty.handler.codec.http.HttpMethod.PATCH;
    }

    @Override
    public boolean isDelete() {
        return this.nettyMethod == io.netty.handler.codec.http.HttpMethod.DELETE;
    }

    @Override
    public boolean isOptions() {
        return this.nettyMethod == io.netty.handler.codec.http.HttpMethod.OPTIONS;
    }

    @Override
    public boolean name(String name) {
        if (name.equalsIgnoreCase("GET")) {
            return this.isGet();
        }
        return this.nettyMethod.name().equalsIgnoreCase(name);
    }

    @Override
    public io.netty.handler.codec.http.HttpMethod getNettyMethod() {
        return this.nettyMethod;
    }

    public String toString() {
        return this.nettyMethod.name().toUpperCase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultHttpMethod that = (DefaultHttpMethod)o;
        return this.nettyMethod.equals((Object)that.nettyMethod);
    }

    public int hashCode() {
        return this.nettyMethod.hashCode();
    }

    public static HttpMethod valueOf(io.netty.handler.codec.http.HttpMethod method) {
        HttpMethod httpMethod = METHODS.get(method);
        return httpMethod == null ? new DefaultHttpMethod(method) : httpMethod;
    }
}

