/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.internal;

import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.http.HttpHeaders;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ratpack.core.http.Headers;
import ratpack.core.http.internal.HttpHeaderDateFormat;
import ratpack.func.MultiValueMap;
import ratpack.func.internal.ImmutableDelegatingMultiValueMap;

public class NettyHeadersBackedHeaders
implements Headers {
    protected final HttpHeaders headers;

    public NettyHeadersBackedHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public String get(CharSequence name) {
        return this.headers.getAsString(name);
    }

    @Override
    public String get(String name) {
        return this.headers.getAsString((CharSequence)name);
    }

    @Override
    public Date getDate(CharSequence name) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        try {
            return HttpHeaderDateFormat.get().parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public Date getDate(String name) {
        return this.getDate((CharSequence)name);
    }

    @Override
    public List<String> getAll(String name) {
        return this.headers.getAllAsString((CharSequence)name);
    }

    @Override
    public boolean contains(String name) {
        return this.headers.contains((CharSequence)name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.headers.getAllAsString(name);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.contains(name);
    }

    @Override
    public Set<String> getNames() {
        return this.headers.names();
    }

    @Override
    public MultiValueMap<String, String> asMultiValueMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String s : this.getNames()) {
            builder.put((Object)s, (Object)this.headers.getAllAsString((CharSequence)s));
        }
        return new ImmutableDelegatingMultiValueMap((Map)builder.build());
    }

    @Override
    public HttpHeaders getNettyHeaders() {
        return this.headers;
    }
}

