/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteSource;
import com.google.common.reflect.TypeToken;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainWildcardMappingBuilder;
import io.netty.util.Mapping;
import java.io.File;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import ratpack.config.ConfigDataBuilder;
import ratpack.config.ConfigSource;
import ratpack.config.EnvironmentParser;
import ratpack.core.server.BaseDir;
import ratpack.core.server.DecodingErrorLevel;
import ratpack.core.server.ServerConfig;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.func.Types;

public interface ServerConfigBuilder
extends ConfigDataBuilder {
    public ServerConfigBuilder baseDir(Path var1);

    default public ServerConfigBuilder baseDir(File file) {
        return this.baseDir(file.toPath());
    }

    default public ServerConfigBuilder findBaseDir() {
        return this.baseDir(BaseDir.find());
    }

    default public ServerConfigBuilder findBaseDir(String markerFilePath) {
        return this.baseDir(BaseDir.find(markerFilePath));
    }

    public ServerConfigBuilder port(int var1);

    public ServerConfigBuilder address(InetAddress var1);

    public ServerConfigBuilder development(boolean var1);

    public ServerConfigBuilder threads(int var1);

    public ServerConfigBuilder registerShutdownHook(boolean var1);

    public ServerConfigBuilder publicAddress(URI var1);

    public ServerConfigBuilder maxContentLength(int var1);

    public ServerConfigBuilder maxChunkSize(int var1);

    public ServerConfigBuilder maxInitialLineLength(int var1);

    public ServerConfigBuilder maxHeaderSize(int var1);

    public ServerConfigBuilder connectTimeoutMillis(int var1);

    public ServerConfigBuilder idleTimeout(Duration var1);

    public ServerConfigBuilder maxMessagesPerRead(int var1);

    public ServerConfigBuilder receiveBufferSize(int var1);

    public ServerConfigBuilder connectQueueSize(int var1);

    public ServerConfigBuilder writeSpinCount(int var1);

    public ServerConfigBuilder portFile(Path var1);

    public ServerConfigBuilder ssl(SslContext var1);

    public ServerConfigBuilder ssl(SslContext var1, Action<? super DomainWildcardMappingBuilder<SslContext>> var2);

    public ServerConfigBuilder ssl(Mapping<String, SslContext> var1);

    public ServerConfigBuilder env();

    public ServerConfigBuilder env(String var1);

    public ServerConfigBuilder args(String[] var1);

    public ServerConfigBuilder args(String var1, String[] var2);

    public ServerConfigBuilder args(String var1, String var2, String[] var3);

    public ServerConfigBuilder props(ByteSource var1);

    public ServerConfigBuilder props(String var1);

    public ServerConfigBuilder props(Path var1);

    public ServerConfigBuilder props(Properties var1);

    public ServerConfigBuilder object(String var1, Object var2);

    public ServerConfigBuilder props(Map<String, String> var1);

    public ServerConfigBuilder props(URL var1);

    public ServerConfigBuilder sysProps();

    public ServerConfigBuilder sysProps(String var1);

    public ServerConfigBuilder onError(Action<? super Throwable> var1);

    public ServerConfigBuilder configureObjectMapper(Action<ObjectMapper> var1);

    public ServerConfigBuilder add(ConfigSource var1);

    public ServerConfigBuilder env(String var1, Function<String, String> var2);

    public ServerConfigBuilder env(EnvironmentParser var1);

    public ServerConfigBuilder json(ByteSource var1);

    public ServerConfigBuilder json(Path var1);

    public ServerConfigBuilder json(String var1);

    public ServerConfigBuilder json(URL var1);

    public ServerConfigBuilder yaml(ByteSource var1);

    public ServerConfigBuilder yaml(Path var1);

    public ServerConfigBuilder yaml(String var1);

    public ServerConfigBuilder yaml(URL var1);

    default public ServerConfigBuilder require(String pointer, Class<?> type) {
        return this.require(pointer, Types.token(type));
    }

    default public ServerConfigBuilder require(String pointer, Type type) {
        return this.require(pointer, Types.token((Type)type));
    }

    public ServerConfigBuilder require(String var1, TypeToken<?> var2);

    public ServerConfig build();

    public ServerConfigBuilder decodingErrorLevel(DecodingErrorLevel var1);
}

