/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.service.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import ratpack.core.server.StartupFailureException;
import ratpack.core.server.internal.DefaultRatpackServer;
import ratpack.core.service.DependsOn;
import ratpack.core.service.Service;
import ratpack.core.service.ServiceDependencies;
import ratpack.core.service.ServiceDependenciesSpec;
import ratpack.core.service.StartEvent;
import ratpack.core.service.StopEvent;
import ratpack.core.service.internal.DefaultEvent;
import ratpack.exec.ExecController;
import ratpack.exec.registry.Registry;
import ratpack.func.Nullable;
import ratpack.func.Predicate;

public class ServicesGraph {
    public static final Logger LOGGER = DefaultRatpackServer.LOGGER;
    private final List<Node> nodes;
    private final AtomicInteger toStartCount = new AtomicInteger();
    private final AtomicInteger toStopCount = new AtomicInteger();
    private final AtomicInteger starting = new AtomicInteger();
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private final ExecController execController;
    private final AtomicReference<StartupFailureException> failureRef = new AtomicReference();
    private volatile boolean startupFailed;

    public ServicesGraph(Registry registry) throws Exception {
        this.nodes = Collections.unmodifiableList(StreamSupport.stream(registry.getAll(Service.class).spliterator(), false).map(x$0 -> new Node((Service)x$0)).collect(Collectors.toList()));
        this.toStartCount.set(this.nodes.size());
        this.toStopCount.set(this.nodes.size());
        this.execController = (ExecController)registry.get(ExecController.class);
        this.defineDependencies(registry);
    }

    private void defineDependencies(Registry registry) throws Exception {
        SpecBacking specBacking = new SpecBacking();
        for (ServiceDependencies dependencies : registry.getAll(ServiceDependencies.class)) {
            dependencies.define(specBacking);
        }
        for (Node node : this.nodes) {
            DependsOn dependsOn = node.getDependsOn();
            if (dependsOn == null) continue;
            specBacking.dependsOn((Predicate<? super Service>)((Predicate)s -> node.getImplClass().isInstance(s)), (Predicate<? super Service>)((Predicate)s -> {
                for (Class<?> dependencyType : dependsOn.value()) {
                    if (!dependencyType.isInstance(s)) continue;
                    return true;
                }
                return false;
            }));
        }
    }

    public synchronized void start(StartEvent startEvent) throws StartupFailureException, InterruptedException {
        if (this.startLatch.getCount() > 0L) {
            if (this.nodes.isEmpty()) {
                this.startLatch.countDown();
            } else {
                LOGGER.info("Initializing " + this.nodes.size() + " services...");
                this.starting.incrementAndGet();
                for (Node node : this.nodes) {
                    if (!node.dependencies.isEmpty()) continue;
                    node.start(startEvent);
                }
                if (this.starting.decrementAndGet() == 0 && this.toStartCount.get() > 0) {
                    this.onCycle();
                }
            }
        }
        this.startLatch.await();
        StartupFailureException startupFailureException = this.failureRef.get();
        if (startupFailureException != null) {
            this.stop(new DefaultEvent(startEvent.getRegistry(), false));
            throw startupFailureException;
        }
    }

    public synchronized void stop(StopEvent stopEvent) throws InterruptedException {
        if (this.stopLatch.getCount() > 0L) {
            this.doStop(stopEvent);
        }
        this.stopLatch.await();
    }

    private void doStop(StopEvent stopEvent) {
        if (this.nodes.isEmpty()) {
            this.stopLatch.countDown();
        } else {
            LOGGER.info("Stopping " + this.nodes.size() + " services...");
            this.nodes.forEach(n -> {
                if (((Node)n).dependentsToStopCount.get() == 0) {
                    n.stop(stopEvent);
                }
            });
        }
    }

    private void serviceDidStart(Node node, StartEvent startEvent) {
        node.dependencies.forEach(Node::dependentStarted);
        if (this.toStartCount.decrementAndGet() == 0) {
            if (this.startupFailed) {
                StartupFailureException exception = this.processFailure();
                this.failureRef.set(exception);
            }
            this.startLatch.countDown();
        } else {
            node.dependents.forEach(n -> n.dependencyStarted(startEvent));
            if (this.starting.decrementAndGet() == 0 && this.toStartCount.get() > 0) {
                this.onCycle();
            }
        }
    }

    private void onCycle() {
        String joinedServiceNames = this.nodes.stream().filter(Node::notStarted).map(n -> ((Node)n).service.getName()).collect(Collectors.joining(", "));
        this.failureRef.set(new StartupFailureException("dependency cycle detected involving the following services: [" + joinedServiceNames + "]"));
        this.startLatch.countDown();
    }

    @Nullable
    private StartupFailureException processFailure() {
        StartupFailureException exception = null;
        for (Node node : this.nodes) {
            if (node.startError == null) continue;
            StartupFailureException nodeException = new StartupFailureException("Service '" + node.service.getName() + "' failed to start", node.startError);
            if (exception == null) {
                exception = nodeException;
                continue;
            }
            exception.addSuppressed(nodeException);
        }
        return exception;
    }

    private void serviceDidStop(Node node, StopEvent stopEvent) {
        if (this.toStopCount.decrementAndGet() == 0) {
            this.stopLatch.countDown();
        } else {
            node.dependencies.forEach(n -> n.dependentStopped(stopEvent));
        }
    }

    public static boolean isOfType(Service service, Class<?> type) {
        return type.isInstance(service);
    }

    private class Node {
        private final Service service;
        private final Set<Node> dependents = new HashSet<Node>();
        private final AtomicInteger dependentsToStopCount = new AtomicInteger();
        private final Set<Node> dependencies = new HashSet<Node>();
        private final AtomicInteger dependenciesToStartCount = new AtomicInteger();
        private final AtomicBoolean stopped = new AtomicBoolean();
        private volatile boolean running;
        private volatile Throwable startError;

        public Node(Service service) {
            this.service = service;
        }

        public DependsOn getDependsOn() {
            return this.getImplClass().getAnnotation(DependsOn.class);
        }

        private Class<?> getImplClass() {
            return this.service.getClass();
        }

        public boolean notStarted() {
            return !this.running;
        }

        public void addDependency(Node node) {
            this.dependencies.add(node);
            this.dependenciesToStartCount.incrementAndGet();
        }

        public void addDependent(Node node) {
            this.dependents.add(node);
        }

        public void dependencyStarted(StartEvent startEvent) {
            if (this.dependenciesToStartCount.decrementAndGet() == 0) {
                this.start(startEvent);
            }
        }

        public void dependentStarted() {
            this.dependentsToStopCount.incrementAndGet();
        }

        public void dependentStopped(StopEvent stopEvent) {
            if (this.dependentsToStopCount.decrementAndGet() <= 0) {
                this.stop(stopEvent);
            }
        }

        public void start(StartEvent startEvent) {
            ServicesGraph.this.starting.incrementAndGet();
            if (ServicesGraph.this.startupFailed) {
                ServicesGraph.this.serviceDidStart(this, startEvent);
                return;
            }
            ServicesGraph.this.execController.fork().onComplete(e -> {
                if (this.startError == null) {
                    this.running = true;
                }
                ServicesGraph.this.serviceDidStart(this, startEvent);
            }).onError(e -> {
                this.startError = e;
                ServicesGraph.this.startupFailed = true;
            }).start(e -> this.service.onStart(startEvent));
        }

        public void stop(StopEvent stopEvent) {
            if (this.stopped.compareAndSet(false, true)) {
                if (this.running) {
                    ServicesGraph.this.execController.fork().onComplete(e -> ServicesGraph.this.serviceDidStop(this, stopEvent)).onError(e -> LOGGER.warn("Service '" + this.service.getName() + "' thrown an exception while stopping.", e)).start(e -> this.service.onStop(stopEvent));
                } else {
                    ServicesGraph.this.serviceDidStop(this, stopEvent);
                }
            }
        }
    }

    private class SpecBacking
    implements ServiceDependenciesSpec {
        private SpecBacking() {
        }

        @Override
        public ServiceDependenciesSpec dependsOn(Predicate<? super Service> dependents, Predicate<? super Service> dependencies) throws Exception {
            ArrayList<Node> dependentNodes = new ArrayList<Node>();
            ArrayList<Node> dependencyNodes = new ArrayList<Node>();
            for (Node node : ServicesGraph.this.nodes) {
                boolean dependent = false;
                if (dependents.apply((Object)node.service)) {
                    dependent = true;
                    dependentNodes.add(node);
                }
                if (!dependencies.apply((Object)node.service)) continue;
                if (dependent) {
                    throw new IllegalStateException("Service '" + node.service.getName() + "' marked as dependent and dependency");
                }
                dependencyNodes.add(node);
            }
            for (Node dependencyNode : dependencyNodes) {
                for (Node dependentNode : dependentNodes) {
                    dependentNode.addDependency(dependencyNode);
                    dependencyNode.addDependent(dependentNode);
                }
            }
            return this;
        }
    }
}

