/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.sse.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;
import io.netty.util.ReferenceCounted;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ratpack.core.sse.ServerSentEvent;
import ratpack.core.sse.ServerSentEventBuilder;
import ratpack.func.Action;

public class ServerSentEventDecoder
implements AutoCloseable {
    private static final ByteBuf NEWLINE_BYTEBUF = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{10}));
    private static final char[] EVENT_ID_FIELD_NAME = "event".toCharArray();
    private static final char[] DATA_FIELD_NAME = "data".toCharArray();
    private static final char[] ID_FIELD_NAME = "id".toCharArray();
    private static final ByteProcessor SKIP_TILL_LINE_DELIMITER_PROCESSOR = value -> !ServerSentEventDecoder.isLineDelimiter((char)value);
    private static final ByteProcessor SKIP_LINE_DELIMITERS_AND_SPACES_PROCESSOR = value -> ServerSentEventDecoder.isLineDelimiter((char)value) || (char)value == ' ';
    private static final ByteProcessor SKIP_COLON_AND_WHITE_SPACE_PROCESSOR = value -> {
        char valueChar = (char)value;
        return valueChar == ':' || valueChar == ' ';
    };
    private static final ByteProcessor SCAN_COLON_PROCESSOR = value -> (char)value != ':';
    private static final ByteProcessor SCAN_EOL_PROCESSOR = value -> !ServerSentEventDecoder.isLineDelimiter((char)value);
    private List<ByteBuf> eventId = new ArrayList<ByteBuf>(1);
    private List<ByteBuf> eventType = new ArrayList<ByteBuf>(1);
    private List<ByteBuf> eventData = new ArrayList<ByteBuf>(1);
    private ByteBuf buffer;
    private Type currentFieldType;
    private State state = State.ReadFieldName;
    private final ByteBufAllocator allocator;
    private final Action<? super ServerSentEvent> emitter;

    public ServerSentEventDecoder(ByteBufAllocator allocator, Action<? super ServerSentEvent> emitter) {
        this.allocator = allocator;
        this.emitter = emitter;
    }

    public void decode(ByteBuf in) throws Exception {
        if (this.state == State.Closed) {
            in.release();
            return;
        }
        try {
            this.doDecode(in);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDecode(ByteBuf in) throws Exception {
        block14: while (in.isReadable()) {
            int readerIndexAtStart = in.readerIndex();
            switch (this.state) {
                case SkipColonAndWhiteSpaces: {
                    if (!ServerSentEventDecoder.skipColonAndWhiteSpaces(in)) break;
                    this.state = State.ReadFieldValue;
                    break;
                }
                case DiscardUntilEOL: {
                    if (!ServerSentEventDecoder.skipTillEOL(in)) break;
                    this.state = State.DiscardEOL;
                    break;
                }
                case DiscardEOL: {
                    byte b = in.readByte();
                    assert (b == 10);
                    this.state = State.ReadFieldName;
                    break;
                }
                case ReadFieldName: {
                    ByteBuf fieldNameBuffer;
                    byte peek = ServerSentEventDecoder.peek(in);
                    if (peek == 10) {
                        in.readByte();
                        this.emit();
                        break;
                    }
                    int endOfNameIndex = ServerSentEventDecoder.scanAndFindColon(in);
                    if (endOfNameIndex == -1) {
                        endOfNameIndex = ServerSentEventDecoder.scanAndFindEndOfLine(in);
                    }
                    if (endOfNameIndex == -1) {
                        if (this.buffer == null) {
                            this.buffer = this.allocator.buffer();
                        }
                        this.buffer.writeBytes(in);
                        break;
                    }
                    int fieldNameLengthInTheCurrentBuffer = endOfNameIndex - readerIndexAtStart;
                    if (this.buffer == null) {
                        fieldNameBuffer = this.allocator.buffer(fieldNameLengthInTheCurrentBuffer, fieldNameLengthInTheCurrentBuffer);
                        in.readBytes(fieldNameBuffer, fieldNameLengthInTheCurrentBuffer);
                    } else {
                        in.readBytes(this.buffer, fieldNameLengthInTheCurrentBuffer);
                        fieldNameBuffer = this.buffer;
                        this.buffer = null;
                    }
                    this.state = State.SkipColonAndWhiteSpaces;
                    try {
                        this.currentFieldType = ServerSentEventDecoder.readCurrentFieldTypeFromBuffer(fieldNameBuffer);
                        continue block14;
                    }
                    finally {
                        if (this.currentFieldType == null) {
                            this.state = State.DiscardUntilEOL;
                        }
                        fieldNameBuffer.release();
                        continue block14;
                    }
                }
                case ReadFieldValue: {
                    List<ByteBuf> field;
                    int endOfLineStartIndex = ServerSentEventDecoder.scanAndFindEndOfLine(in);
                    if (endOfLineStartIndex == -1) {
                        if (this.buffer == null) {
                            this.buffer = this.allocator.buffer(in.readableBytes());
                        }
                        this.buffer.writeBytes(in);
                        break;
                    }
                    int bytesAvailableInThisIteration = endOfLineStartIndex - readerIndexAtStart;
                    if (this.buffer == null) {
                        this.buffer = this.allocator.buffer(bytesAvailableInThisIteration, bytesAvailableInThisIteration);
                    }
                    this.buffer.writeBytes(in, bytesAvailableInThisIteration);
                    switch (this.currentFieldType) {
                        case Data: {
                            field = this.eventData;
                            break;
                        }
                        case Id: {
                            field = this.eventId;
                            break;
                        }
                        default: {
                            field = this.eventType;
                        }
                    }
                    field.add(this.buffer);
                    this.buffer = null;
                    this.state = State.DiscardUntilEOL;
                }
            }
        }
    }

    private void emit() throws Exception {
        String data;
        String type;
        boolean any = false;
        ServerSentEventBuilder event = ServerSentEvent.builder();
        String id = this.str(this.eventId);
        if (id != null) {
            any = true;
            event.id(id);
        }
        if ((type = this.str(this.eventType)) != null) {
            any = true;
            event.event(type);
        }
        if ((data = this.str(this.eventData)) != null) {
            any = true;
            event.data(data);
        }
        if (any) {
            this.emitter.execute((Object)event.build());
        }
        this.state = State.ReadFieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String str(List<ByteBuf> bufs) {
        if (bufs.isEmpty()) {
            return null;
        }
        try {
            String str;
            if (bufs.size() == 1) {
                ByteBuf buf = bufs.get(0);
                str = buf.toString(StandardCharsets.UTF_8);
                buf.release();
            } else {
                CompositeByteBuf composite = this.allocator.compositeBuffer(bufs.size() * 2 - 1);
                try {
                    Iterator<ByteBuf> iterator = bufs.iterator();
                    composite.addComponent(true, iterator.next());
                    while (iterator.hasNext()) {
                        composite.addComponent(true, NEWLINE_BYTEBUF);
                        composite.addComponent(true, iterator.next());
                    }
                    str = composite.toString(StandardCharsets.UTF_8);
                }
                finally {
                    composite.release();
                }
            }
            String string = str;
            return string;
        }
        finally {
            bufs.clear();
        }
    }

    private static Type readCurrentFieldTypeFromBuffer(ByteBuf fieldNameBuffer) {
        Type toReturn = Type.Data;
        ServerSentEventDecoder.skipLineDelimiters(fieldNameBuffer);
        int readableBytes = fieldNameBuffer.readableBytes();
        int readerIndexAtStart = fieldNameBuffer.readerIndex();
        char[] fieldNameToVerify = DATA_FIELD_NAME;
        boolean verified = false;
        int actualFieldNameIndexToCheck = 0;
        block5: for (int i = readerIndexAtStart; i < readerIndexAtStart + readableBytes; ++i) {
            char charAtI = (char)fieldNameBuffer.getByte(i);
            if (i == readerIndexAtStart) {
                switch (charAtI) {
                    case 'e': {
                        fieldNameToVerify = EVENT_ID_FIELD_NAME;
                        toReturn = Type.EventType;
                        continue block5;
                    }
                    case 'd': {
                        fieldNameToVerify = DATA_FIELD_NAME;
                        toReturn = Type.Data;
                        continue block5;
                    }
                    case 'i': {
                        fieldNameToVerify = ID_FIELD_NAME;
                        toReturn = Type.Id;
                        continue block5;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (++actualFieldNameIndexToCheck >= fieldNameToVerify.length || charAtI != fieldNameToVerify[actualFieldNameIndexToCheck]) {
                verified = false;
                break;
            }
            verified = true;
        }
        if (verified) {
            return toReturn;
        }
        return null;
    }

    @Override
    public void close() {
        if (this.eventId != null) {
            this.eventId.forEach(ReferenceCounted::release);
            this.eventId = null;
        }
        if (this.eventType != null) {
            this.eventType.forEach(ReferenceCounted::release);
            this.eventType = null;
        }
        if (this.eventData != null) {
            this.eventData.forEach(ReferenceCounted::release);
            this.eventData = null;
        }
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
        this.state = State.Closed;
    }

    private static int scanAndFindColon(ByteBuf byteBuf) {
        return byteBuf.forEachByte(SCAN_COLON_PROCESSOR);
    }

    private static int scanAndFindEndOfLine(ByteBuf byteBuf) {
        return byteBuf.forEachByte(SCAN_EOL_PROCESSOR);
    }

    private static boolean skipLineDelimiters(ByteBuf byteBuf) {
        return ServerSentEventDecoder.skipTillMatching(byteBuf, SKIP_LINE_DELIMITERS_AND_SPACES_PROCESSOR);
    }

    private static boolean skipColonAndWhiteSpaces(ByteBuf byteBuf) {
        return ServerSentEventDecoder.skipTillMatching(byteBuf, SKIP_COLON_AND_WHITE_SPACE_PROCESSOR);
    }

    private static boolean skipTillEOL(ByteBuf in) {
        return ServerSentEventDecoder.skipTillMatching(in, SKIP_TILL_LINE_DELIMITER_PROCESSOR);
    }

    private static boolean skipTillMatching(ByteBuf byteBuf, ByteProcessor processor) {
        int lastIndexProcessed = byteBuf.forEachByte(processor);
        if (lastIndexProcessed == -1) {
            byteBuf.readerIndex(byteBuf.readerIndex() + byteBuf.readableBytes());
        } else {
            byteBuf.readerIndex(lastIndexProcessed);
        }
        return lastIndexProcessed != -1;
    }

    private static boolean isLineDelimiter(char c) {
        return c == '\n';
    }

    private static byte peek(ByteBuf buffer) {
        return buffer.getByte(buffer.readerIndex());
    }

    private static enum Type {
        Data,
        Id,
        EventType;

    }

    private static enum State {
        ReadFieldName,
        SkipColonAndWhiteSpaces,
        ReadFieldValue,
        DiscardUntilEOL,
        DiscardEOL,
        Closed;

    }
}

