/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.websocket.internal;

import ratpack.core.websocket.WebSocket;
import ratpack.core.websocket.WebSocketClose;
import ratpack.core.websocket.WebSocketHandler;
import ratpack.core.websocket.WebSocketMessage;
import ratpack.func.Action;
import ratpack.func.Exceptions;
import ratpack.func.Function;

public class BuiltWebSocketHandler<T>
implements WebSocketHandler<T> {
    private final Function<? super WebSocket, T> open;
    private final Action<? super WebSocketClose<T>> close;
    private final Action<? super WebSocketMessage<T>> message;

    public BuiltWebSocketHandler(Function<? super WebSocket, T> open, Action<? super WebSocketClose<T>> close, Action<? super WebSocketMessage<T>> message) {
        this.open = open;
        this.close = close;
        this.message = message;
    }

    @Override
    public T onOpen(WebSocket webSocket) throws Exception {
        return (T)this.open.apply((Object)webSocket);
    }

    @Override
    public void onClose(WebSocketClose<T> close) {
        try {
            this.close.execute(close);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    @Override
    public void onMessage(WebSocketMessage<T> frame) {
        try {
            this.message.execute(frame);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }
}

