/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.websocket.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import ratpack.core.handling.Context;
import ratpack.core.handling.direct.DirectChannelAccess;
import ratpack.core.http.Request;
import ratpack.core.server.PublicAddress;
import ratpack.core.websocket.WebSocketHandler;
import ratpack.core.websocket.internal.DefaultWebSocket;
import ratpack.core.websocket.internal.DefaultWebSocketClose;
import ratpack.core.websocket.internal.DefaultWebSocketMessage;
import ratpack.func.Action;
import ratpack.func.Exceptions;

public class WebSocketEngine {
    public static <T> void connect(Context context, String path, int maxLength, WebSocketHandler<T> handler) {
        URI wsPath;
        PublicAddress publicAddress = (PublicAddress)context.get(PublicAddress.class);
        URI address = publicAddress.get();
        URI httpPath = address.resolve(path);
        try {
            wsPath = new URI("ws", httpPath.getUserInfo(), httpPath.getHost(), httpPath.getPort(), httpPath.getPath(), httpPath.getQuery(), httpPath.getFragment());
        }
        catch (URISyntaxException e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(wsPath.toString(), null, false, maxLength);
        Request request = context.getRequest();
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod().getName());
        DefaultFullHttpRequest nettyRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, request.getUri());
        nettyRequest.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)request.getHeaders().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION));
        nettyRequest.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)request.getHeaders().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY));
        WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)nettyRequest);
        DirectChannelAccess directChannelAccess = context.getDirectChannelAccess();
        Channel channel = directChannelAccess.getChannel();
        if (!channel.config().isAutoRead()) {
            channel.config().setAutoRead(true);
        }
        handshaker.handshake(channel, (FullHttpRequest)nettyRequest).addListener(new HandshakeFutureListener<T>(context, handshaker, handler));
    }

    private static class HandshakeFutureListener<T>
    implements ChannelFutureListener {
        private final Context context;
        private final WebSocketServerHandshaker handshaker;
        private final WebSocketHandler<T> handler;
        private volatile T openResult;
        private final CountDownLatch openLatch = new CountDownLatch(1);

        public HandshakeFutureListener(Context context, WebSocketServerHandshaker handshaker, WebSocketHandler<T> handler) {
            this.context = context;
            this.handshaker = handshaker;
            this.handler = handler;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                AtomicBoolean open = new AtomicBoolean(true);
                DefaultWebSocket webSocket = new DefaultWebSocket(this.context.getDirectChannelAccess().getChannel(), open, () -> {
                    try {
                        this.handler.onClose(new DefaultWebSocketClose<T>(false, this.openResult));
                    }
                    catch (Exception e) {
                        throw Exceptions.uncheck((Throwable)e);
                    }
                });
                DirectChannelAccess directAccessChannel = this.context.getDirectChannelAccess();
                Channel channel = directAccessChannel.getChannel();
                channel.closeFuture().addListener(fu -> {
                    try {
                        this.handler.onClose(new DefaultWebSocketClose<T>(true, this.openResult));
                    }
                    catch (Exception e) {
                        throw Exceptions.uncheck((Throwable)e);
                    }
                });
                directAccessChannel.takeOwnership((Action<Object>)((Action)msg -> {
                    this.openLatch.await();
                    if (channel.isOpen() && msg instanceof WebSocketFrame) {
                        WebSocketFrame frame = (WebSocketFrame)msg;
                        if (frame instanceof CloseWebSocketFrame) {
                            open.set(false);
                            this.handshaker.close(channel, (CloseWebSocketFrame)frame).addListener(future1 -> this.handler.onClose(new DefaultWebSocketClose<T>(true, this.openResult)));
                            return;
                        }
                        if (frame instanceof PingWebSocketFrame) {
                            channel.writeAndFlush((Object)new PongWebSocketFrame(frame.content()));
                            return;
                        }
                        if (frame instanceof TextWebSocketFrame) {
                            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)frame;
                            this.handler.onMessage(new DefaultWebSocketMessage<T>(webSocket, textWebSocketFrame.text(), this.openResult));
                            frame.release();
                        }
                    }
                }));
                try {
                    this.openResult = this.handler.onOpen(webSocket);
                }
                catch (Exception e) {
                    this.handshaker.close(this.context.getDirectChannelAccess().getChannel(), new CloseWebSocketFrame(1011, e.getMessage()));
                }
                this.openLatch.countDown();
            } else {
                this.context.error(Exceptions.toException((Throwable)future.cause()));
            }
        }
    }
}

