/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside;

import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import io.netty.util.CharsetUtil;
import java.time.Duration;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import ratpack.guice.ConfigurableModule;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.session.clientside.Crypto;
import ratpack.session.clientside.SessionService;
import ratpack.session.clientside.Signer;
import ratpack.session.clientside.internal.CookieBasedSessionStorageBindingHandler;
import ratpack.session.clientside.internal.DefaultClientSessionService;
import ratpack.session.clientside.internal.DefaultCrypto;
import ratpack.session.clientside.internal.DefaultSigner;

public class ClientSideSessionsModule
extends ConfigurableModule<Config> {
    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), HandlerDecorator.class).addBinding().toProvider(CookieBasedSessionStorageHandlerDecorator.class);
    }

    @Provides
    @Singleton
    Signer provideSigner(Config config) {
        byte[] token = config.getSecretToken().getBytes(CharsetUtil.UTF_8);
        return new DefaultSigner(new SecretKeySpec(token, config.getMacAlgorithm()));
    }

    @Provides
    @Singleton
    Crypto provideCrypto(Config config) {
        DefaultCrypto crypto = null;
        if (config.getSecretKey() != null && config.getCipherAlgorithm() != null) {
            byte[] key = config.getSecretKey().getBytes(CharsetUtil.UTF_8);
            crypto = new DefaultCrypto(key, config.getCipherAlgorithm());
        }
        return crypto;
    }

    @Provides
    @Singleton
    SessionService provideSessionService(Config config, Signer signer, Crypto crypto) {
        SessionService sessionService = config.getSessionService();
        if (sessionService == null) {
            sessionService = new DefaultClientSessionService(signer, crypto);
        }
        return sessionService;
    }

    public static class Config {
        public static final TypeToken<Config> COOKIE_SESSION_CONFIG_TYPE_TOKEN = TypeToken.of(Config.class);
        private String sessionName = "ratpack_session";
        private String secretToken = Long.toString(System.currentTimeMillis() / 10000L);
        private String macAlgorithm = "HmacSHA1";
        private String secretKey;
        private String cipherAlgorithm = "AES/CBC/PKCS5Padding";
        private String path = "/";
        private String domain;
        private int maxCookieSize = 2048;
        private Duration maxInactivityInterval = Duration.ofSeconds(120L);
        private SessionService sessionService;

        public String getSessionName() {
            return this.sessionName;
        }

        public void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        public String getSecretToken() {
            return this.secretToken;
        }

        public void setSecretToken(String secretToken) {
            this.secretToken = secretToken;
        }

        public String getMacAlgorithm() {
            return this.macAlgorithm;
        }

        public void setMacAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getCipherAlgorithm() {
            return this.cipherAlgorithm;
        }

        public void setCipherAlgorithm(String cipherAlgorithm) {
            this.cipherAlgorithm = cipherAlgorithm;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public int getMaxCookieSize() {
            return this.maxCookieSize;
        }

        public void setMaxCookieSize(int maxCookieSize) {
            this.maxCookieSize = maxCookieSize < 1024 || maxCookieSize > 4096 ? 2048 : maxCookieSize;
        }

        public Duration getMaxInactivityInterval() {
            return this.maxInactivityInterval;
        }

        public void setMaxInactivityInterval(Duration maxInactivityInterval) {
            this.maxInactivityInterval = maxInactivityInterval;
        }

        public SessionService getSessionService() {
            return this.sessionService;
        }

        public void setSessionService(SessionService sessionService) {
            this.sessionService = sessionService;
        }
    }

    private static class CookieBasedSessionStorageHandlerDecorator
    implements Provider<HandlerDecorator> {
        private final SessionService sessionService;
        private final Config config;

        @Inject
        public CookieBasedSessionStorageHandlerDecorator(SessionService sessionService, Config config) {
            this.sessionService = sessionService;
            this.config = config;
        }

        public HandlerDecorator get() {
            return HandlerDecorator.prepend((Handler)new CookieBasedSessionStorageBindingHandler(this.sessionService, this.config.getSessionName(), this.config.getPath(), this.config.getDomain(), this.config.getMaxCookieSize(), this.config.getMaxInactivityInterval()));
        }
    }
}

