/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside.internal;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.Cookie;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.reactivestreams.Publisher;
import ratpack.exec.ExecControl;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.ResponseMetaData;
import ratpack.session.clientside.SessionService;
import ratpack.session.store.internal.ChangeTrackingSessionStorage;
import ratpack.stream.Streams;

public class CookieBasedSessionStorageBindingHandler
implements Handler {
    private final SessionService sessionService;
    private final String sessionName;
    private final String path;
    private final String domain;
    private final int maxCookieSize;
    private final Duration maxInactivityInterval;
    private static final String LAST_ACCESS_TIME_TOKEN = "$LAT$";

    public CookieBasedSessionStorageBindingHandler(SessionService sessionService, String sessionName, String path, String domain, int maxCookieSize, Duration maxInactivityInterval) {
        this.sessionService = sessionService;
        this.sessionName = sessionName;
        this.path = path;
        this.domain = domain;
        this.maxCookieSize = maxCookieSize;
        this.maxInactivityInterval = maxInactivityInterval;
    }

    public void handle(Context context) {
        context.getRequest().addLazy(ChangeTrackingSessionStorage.class, () -> {
            Cookie[] sessionCookies = this.findSessionCookies(context.getRequest().getCookies());
            ConcurrentMap<String, Object> sessionMap = this.sessionService.deserializeSession(sessionCookies);
            ChangeTrackingSessionStorage changeTrackingSessionStorage = null;
            if (!this.maxInactivityInterval.isNegative()) {
                long lastAccessTime = Long.valueOf((String)sessionMap.getOrDefault(LAST_ACCESS_TIME_TOKEN, "-1"));
                long currentTime = System.currentTimeMillis();
                long maxInactivityIntervalMillis = this.maxInactivityInterval.toMillis();
                if (lastAccessTime == -1L || currentTime - lastAccessTime > maxInactivityIntervalMillis) {
                    sessionMap.remove(LAST_ACCESS_TIME_TOKEN);
                    changeTrackingSessionStorage = new ChangeTrackingSessionStorage(sessionMap, (ExecControl)context);
                    sessionMap.clear();
                }
            }
            if (sessionMap.size() > 0) {
                sessionMap.remove(LAST_ACCESS_TIME_TOKEN);
            }
            if (changeTrackingSessionStorage != null) {
                return changeTrackingSessionStorage;
            }
            return new ChangeTrackingSessionStorage(sessionMap, (ExecControl)context);
        });
        context.getResponse().beforeSend(responseMetaData -> {
            ChangeTrackingSessionStorage storage;
            Optional storageOptional = context.getRequest().maybeGet(ChangeTrackingSessionStorage.class);
            if (storageOptional.isPresent() && (storage = (ChangeTrackingSessionStorage)storageOptional.get()).hasChanged()) {
                HashSet entries = new HashSet();
                storage.getKeys().then(keys -> context.stream((Publisher)Streams.publish((Iterable)keys)).flatMap(key -> storage.get((String)key, Object.class).map(value -> {
                    if (value.isPresent()) {
                        return new AbstractMap.SimpleImmutableEntry((String)key, value.get());
                    }
                    return null;
                })).toList().then(entryList -> {
                    for (Map.Entry entry : entryList) {
                        if (entry == null) continue;
                        entries.add(entry);
                    }
                    int initialSessionCookieCount = this.findSessionCookies(context.getRequest().getCookies()).length;
                    int currentSessionCookieCount = 0;
                    if (!entries.isEmpty()) {
                        entries.add(new AbstractMap.SimpleImmutableEntry<String, String>(LAST_ACCESS_TIME_TOKEN, Long.toString(System.currentTimeMillis())));
                        ByteBufAllocator bufferAllocator = (ByteBufAllocator)context.get(ByteBufAllocator.class);
                        String[] cookieValuePartitions = this.sessionService.serializeSession(bufferAllocator, entries, this.maxCookieSize);
                        for (int i = 0; i < cookieValuePartitions.length; ++i) {
                            this.addSessionCookie((ResponseMetaData)responseMetaData, this.sessionName + "_" + i, cookieValuePartitions[i], this.path, this.domain);
                        }
                        currentSessionCookieCount = cookieValuePartitions.length;
                    }
                    for (int i = currentSessionCookieCount; i < initialSessionCookieCount; ++i) {
                        this.invalidateSessionCookie((ResponseMetaData)responseMetaData, this.sessionName + "_" + i, this.path, this.domain);
                    }
                }));
            }
        });
        context.next();
    }

    private Cookie[] findSessionCookies(Set<Cookie> cookies) {
        if (cookies == null) {
            return new Cookie[0];
        }
        return (Cookie[])cookies.stream().filter(c -> c.name().startsWith(this.sessionName)).sorted((c1, c2) -> c1.name().compareTo(c2.name())).toArray(Cookie[]::new);
    }

    private void invalidateSessionCookie(ResponseMetaData responseMetaData, String cookieName, String path, String domain) {
        Cookie sessionCookie = responseMetaData.expireCookie(cookieName);
        if (path != null) {
            sessionCookie.setPath(path);
        }
        if (domain != null) {
            sessionCookie.setDomain(domain);
        }
    }

    private void addSessionCookie(ResponseMetaData responseMetaData, String name, String value, String path, String domain) {
        Cookie sessionCookie = responseMetaData.cookie(name, value);
        if (path != null) {
            sessionCookie.setPath(path);
        }
        if (domain != null) {
            sessionCookie.setDomain(domain);
        }
    }
}

