/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside.internal;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ratpack.session.clientside.Crypto;
import ratpack.session.clientside.SessionService;
import ratpack.session.clientside.Signer;
import ratpack.util.Exceptions;

public class DefaultClientSessionService
implements SessionService {
    private static final Base64.Encoder ENCODER = Base64.getUrlEncoder();
    private static final Base64.Decoder DECODER = Base64.getUrlDecoder();
    private static final Escaper ESCAPER = UrlEscapers.urlFormParameterEscaper();
    private static final ByteBuf EQUALS = Unpooled.unreleasableBuffer((ByteBuf)ByteBufUtil.encodeString((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap("="), (Charset)CharsetUtil.UTF_8));
    private static final ByteBuf AMPERSAND = Unpooled.unreleasableBuffer((ByteBuf)ByteBufUtil.encodeString((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap("&"), (Charset)CharsetUtil.UTF_8));
    private static final String SESSION_SEPARATOR = ":";
    private final Signer signer;
    private final Crypto crypto;

    public DefaultClientSessionService(Signer signer, Crypto crypto) {
        this.signer = signer;
        this.crypto = crypto;
    }

    @Override
    public String[] serializeSession(ByteBufAllocator bufferAllocator, Set<Map.Entry<String, Object>> entries, int maxCookieSize) {
        String serializedSession = this.serializeSession(bufferAllocator, entries);
        int sessionSize = serializedSession.length();
        if (sessionSize <= maxCookieSize) {
            return new String[]{serializedSession};
        }
        int numOfPartitions = (int)Math.ceil((double)sessionSize / (double)maxCookieSize);
        String[] partitions = new String[numOfPartitions];
        for (int i = 0; i < numOfPartitions; ++i) {
            int from = i * maxCookieSize;
            int to = Math.min(from + maxCookieSize, sessionSize - 1);
            partitions[i] = serializedSession.substring(from, to);
        }
        return partitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serializeSession(ByteBufAllocator bufferAllocator, Set<Map.Entry<String, Object>> entries) {
        ByteBuf[] buffers = new ByteBuf[3 * entries.size() + entries.size() - 1];
        try {
            int i = 0;
            for (Map.Entry<String, Object> entry : entries) {
                buffers[i++] = this.encode(bufferAllocator, entry.getKey());
                buffers[i++] = EQUALS;
                buffers[i++] = this.encode(bufferAllocator, entry.getValue().toString());
                if (i >= buffers.length) continue;
                buffers[i++] = AMPERSAND;
            }
            ByteBuf payloadBuffer = Unpooled.wrappedBuffer((int)buffers.length, (ByteBuf[])buffers);
            byte[] payloadBytes = new byte[payloadBuffer.readableBytes()];
            payloadBuffer.getBytes(0, payloadBytes);
            if (this.crypto != null) {
                payloadBytes = this.crypto.encrypt(payloadBuffer);
                payloadBuffer = Unpooled.wrappedBuffer((byte[])payloadBytes);
            }
            String payloadString = ENCODER.encodeToString(payloadBytes);
            byte[] digest = this.signer.sign(payloadBuffer);
            String digestString = ENCODER.encodeToString(digest);
            String string = payloadString + SESSION_SEPARATOR + digestString;
            return string;
        }
        finally {
            for (ByteBuf buffer : buffers) {
                if (buffer == null) continue;
                buffer.release();
            }
        }
    }

    private ByteBuf encode(ByteBufAllocator bufferAllocator, String value) {
        String escaped = ESCAPER.escape(value);
        return ByteBufUtil.encodeString((ByteBufAllocator)bufferAllocator, (CharBuffer)CharBuffer.wrap(escaped), (Charset)CharsetUtil.UTF_8);
    }

    @Override
    public ConcurrentMap<String, Object> deserializeSession(Cookie[] sessionCookies) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sessionCookies.length; ++i) {
            sb.append(sessionCookies[i].value());
        }
        return this.deserializeSession(sb.toString());
    }

    private ConcurrentMap<String, Object> deserializeSession(String cookieValue) {
        String[] parts;
        ConcurrentHashMap<String, Object> sessionStorage = new ConcurrentHashMap<String, Object>();
        String encodedPairs = cookieValue;
        if (encodedPairs != null && (parts = encodedPairs.split(SESSION_SEPARATOR)).length == 2) {
            byte[] urlEncoded = DECODER.decode(parts[0]);
            byte[] digest = DECODER.decode(parts[1]);
            try {
                byte[] expectedDigest = this.signer.sign(Unpooled.wrappedBuffer((byte[])urlEncoded));
                if (Arrays.equals(digest, expectedDigest)) {
                    byte[] message = this.crypto == null ? urlEncoded : this.crypto.decrypt(Unpooled.wrappedBuffer((byte[])urlEncoded));
                    String payload = new String(message, CharsetUtil.UTF_8);
                    QueryStringDecoder queryStringDecoder = new QueryStringDecoder(payload, CharsetUtil.UTF_8, false);
                    Map decoded = queryStringDecoder.parameters();
                    for (Map.Entry entry : decoded.entrySet()) {
                        String value = ((List)entry.getValue()).isEmpty() ? null : (String)((List)entry.getValue()).get(0);
                        sessionStorage.put((String)entry.getKey(), value);
                    }
                }
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }
        return sessionStorage;
    }
}

