/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.store.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecControl;
import ratpack.session.SessionListener;
import ratpack.session.store.SessionStorage;
import ratpack.session.store.SessionStore;
import ratpack.session.store.internal.DefaultSessionStorage;
import ratpack.util.Exceptions;

public class DefaultSessionStore
implements SessionStore,
SessionListener {
    private final Cache<String, SessionStorage> storage;

    public DefaultSessionStore(int maxEntries, int ttlMinutes) {
        this.storage = CacheBuilder.newBuilder().maximumSize((long)maxEntries).expireAfterAccess((long)ttlMinutes, TimeUnit.MINUTES).build();
    }

    @Override
    public void sessionInitiated(String id) {
    }

    @Override
    public void sessionTerminated(String id) {
        this.storage.invalidate((Object)id);
    }

    @Override
    public SessionStorage get(String sessionId) {
        try {
            return (SessionStorage)this.storage.get((Object)sessionId, () -> new DefaultSessionStorage(new ConcurrentHashMap<String, Object>(), ExecControl.current()));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw Exceptions.uncheck((Throwable)Exceptions.toException((Throwable)e.getCause()));
        }
    }

    @Override
    public long size() {
        return this.storage.size();
    }
}

