/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.parser.core.topology;

import io.siddhi.parser.core.topology.InputStreamDataHolder;
import io.siddhi.parser.core.topology.OutputStreamDataHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SiddhiQueryGroup {
    private String name;
    private int parallelism;
    private String siddhiApp;
    private Map<String, InputStreamDataHolder> inputStreams;
    private Map<String, OutputStreamDataHolder> outputStreams;
    private boolean messagingSourceAvailable = false;
    private List<String> queryList;
    private boolean isReceiverQueryGroup;

    public SiddhiQueryGroup(String name, int parallelism) {
        this.name = name;
        this.parallelism = parallelism;
        this.queryList = new ArrayList<String>();
        this.siddhiApp = " ";
        this.inputStreams = new HashMap<String, InputStreamDataHolder>();
        this.outputStreams = new HashMap<String, OutputStreamDataHolder>();
    }

    public List<String> getQueryList() {
        return this.queryList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public String getSiddhiApp() {
        StringBuilder stringBuilder = new StringBuilder("@App:name(\"${appName}\") \n");
        for (InputStreamDataHolder inputStreamDataHolder : this.inputStreams.values()) {
            this.siddhiApp = inputStreamDataHolder.getStreamDefinition();
            if (this.siddhiApp == null) continue;
            stringBuilder.append(this.siddhiApp).append(";\n");
        }
        for (OutputStreamDataHolder outputStreamDataHolder : this.outputStreams.values()) {
            this.siddhiApp = outputStreamDataHolder.getStreamDefinition();
            if (this.siddhiApp == null) continue;
            stringBuilder.append(this.siddhiApp).append(";\n");
        }
        for (String aQueryList : this.queryList) {
            stringBuilder.append(aQueryList).append(";\n");
        }
        this.siddhiApp = stringBuilder.toString();
        return stringBuilder.toString();
    }

    public void addQuery(String query) {
        this.queryList.add(query);
    }

    public void addQueryAtFirst(String query) {
        this.queryList.add(0, query);
    }

    public void addOutputStream(String key, OutputStreamDataHolder outputStreamDataHolder) {
        if (outputStreamDataHolder != null) {
            this.outputStreams.put(key, outputStreamDataHolder);
        }
    }

    public void addInputStreams(Map<String, InputStreamDataHolder> inputStreamDataHolderMap) {
        if (inputStreamDataHolderMap != null) {
            this.inputStreams.putAll(inputStreamDataHolderMap);
        }
    }

    public Map<String, InputStreamDataHolder> getInputStreams() {
        return this.inputStreams;
    }

    public Map<String, OutputStreamDataHolder> getOutputStreams() {
        return this.outputStreams;
    }

    public boolean isReceiverQueryGroup() {
        return this.isReceiverQueryGroup;
    }

    public void setReceiverQueryGroup(boolean receiverQueryGroup) {
        this.isReceiverQueryGroup = receiverQueryGroup;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public boolean isMessagingSourceAvailable() {
        return this.messagingSourceAvailable;
    }

    public void setMessagingSourceAvailable(boolean messagingSourceAvailable) {
        this.messagingSourceAvailable = messagingSourceAvailable;
    }
}

