/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.parser.core.topology;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.partition.PartitionRuntime;
import io.siddhi.core.query.QueryRuntime;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.core.table.Table;
import io.siddhi.core.window.Window;
import io.siddhi.parser.SiddhiParserDataHolder;
import io.siddhi.parser.core.SiddhiTopologyCreator;
import io.siddhi.parser.core.topology.InputStreamDataHolder;
import io.siddhi.parser.core.topology.OutputStreamDataHolder;
import io.siddhi.parser.core.topology.PublishingStrategyDataHolder;
import io.siddhi.parser.core.topology.SiddhiQueryGroup;
import io.siddhi.parser.core.topology.SiddhiTopology;
import io.siddhi.parser.core.topology.SiddhiTopologyDataHolder;
import io.siddhi.parser.core.topology.StrategyParallelismComparator;
import io.siddhi.parser.core.topology.StreamDataHolder;
import io.siddhi.parser.core.topology.SubscriptionStrategyDataHolder;
import io.siddhi.parser.core.util.EventHolder;
import io.siddhi.parser.core.util.SiddhiTopologyCreatorConstants;
import io.siddhi.parser.core.util.TransportStrategy;
import io.siddhi.query.api.SiddhiApp;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.definition.WindowDefinition;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.execution.ExecutionElement;
import io.siddhi.query.api.execution.partition.Partition;
import io.siddhi.query.api.execution.partition.ValuePartitionType;
import io.siddhi.query.api.execution.query.Query;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.util.AnnotationHelper;
import io.siddhi.query.api.util.ExceptionUtil;
import io.siddhi.query.compiler.SiddhiCompiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.log4j.Logger;

public class SiddhiTopologyCreatorImpl
implements SiddhiTopologyCreator {
    private static final Logger log = Logger.getLogger(SiddhiTopologyCreatorImpl.class);
    private static final String DEFAULT_MESSAGING_SYSTEM = "nats";
    private SiddhiTopologyDataHolder siddhiTopologyDataHolder;
    private SiddhiApp siddhiApp;
    private String siddhiAppName;
    private SiddhiAppRuntime siddhiAppRuntime;
    private String userDefinedSiddhiApp;
    private boolean transportChannelCreationEnabled = true;
    private boolean isUserGiveSourceStateful = false;
    private SiddhiQueryGroup passThroughSiddhiQueryGroup;

    @Override
    public SiddhiTopology createTopology(String userDefinedSiddhiApp) {
        this.userDefinedSiddhiApp = userDefinedSiddhiApp;
        this.siddhiApp = SiddhiCompiler.parse((String)userDefinedSiddhiApp);
        this.siddhiAppRuntime = SiddhiParserDataHolder.getSiddhiManager().createSiddhiAppRuntime(userDefinedSiddhiApp);
        this.siddhiAppName = this.getSiddhiAppName();
        this.siddhiTopologyDataHolder = new SiddhiTopologyDataHolder(this.siddhiAppName, userDefinedSiddhiApp);
        int parallelism = SiddhiTopologyCreatorConstants.DEFAULT_PARALLEL;
        String passthroughExecGroupName = this.siddhiTopologyDataHolder.getSiddhiAppName() + "-" + "passthrough" + "-" + new Random().nextInt(99999);
        this.passThroughSiddhiQueryGroup = new SiddhiQueryGroup(passthroughExecGroupName, parallelism);
        String defaultExecGroupName = this.siddhiAppName + "-" + UUID.randomUUID();
        for (ExecutionElement executionElement : this.siddhiApp.getExecutionElementList()) {
            String execGroupName = defaultExecGroupName;
            SiddhiQueryGroup siddhiQueryGroup = this.createSiddhiQueryGroup(execGroupName, parallelism);
            this.addExecutionElement(executionElement, siddhiQueryGroup, execGroupName);
        }
        this.checkUserGivenSourceDistribution();
        this.assignPublishingStrategyOutputStream();
        this.checkForInmemoryBridges();
        this.cleanInnerGroupStreams(this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().values());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Topology was created with " + this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().values().size() + " groups. Following are the partial Siddhi apps."));
            for (SiddhiQueryGroup debugSiddhiQueryGroup : this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().values()) {
                log.debug((Object)debugSiddhiQueryGroup.getSiddhiApp());
            }
        }
        return new SiddhiTopology(this.siddhiTopologyDataHolder.getSiddhiAppName(), new ArrayList<SiddhiQueryGroup>(this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().values()), this.transportChannelCreationEnabled, this.isStatefulApp(), this.isUserGiveSourceStateful);
    }

    @Override
    public boolean isAppStateful(String userDefinedSiddhiApp) {
        this.siddhiAppRuntime = SiddhiParserDataHolder.getSiddhiManager().createSiddhiAppRuntime(userDefinedSiddhiApp);
        return this.isStatefulApp();
    }

    private boolean isStatefulApp() {
        for (List sourceList : this.siddhiAppRuntime.getSources()) {
            for (Source source : sourceList) {
                if (!source.isStateful()) continue;
                if (source.getType().equalsIgnoreCase(DEFAULT_MESSAGING_SYSTEM)) {
                    this.isUserGiveSourceStateful = true;
                }
                return true;
            }
        }
        for (List sinkList : this.siddhiAppRuntime.getSinks()) {
            for (Sink sink : sinkList) {
                if (!sink.isStateful()) continue;
                return true;
            }
        }
        for (QueryRuntime queryRuntime : this.siddhiAppRuntime.getQueries()) {
            if (!queryRuntime.isStateful()) continue;
            return true;
        }
        for (PartitionRuntime partitionRuntime : this.siddhiAppRuntime.getPartitions()) {
            for (QueryRuntime queryRuntime : partitionRuntime.getQueries()) {
                if (!queryRuntime.isStateful()) continue;
                return true;
            }
        }
        for (Table table : this.siddhiAppRuntime.getTables()) {
            if (!table.isStateful()) continue;
            return true;
        }
        for (Window window : this.siddhiAppRuntime.getWindows()) {
            if (!window.isStateful()) continue;
            return true;
        }
        return false;
    }

    private void checkForInmemoryBridges() {
        ArrayList<SiddhiQueryGroup> siddhiQueryGroupsList = new ArrayList<SiddhiQueryGroup>(this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().values());
        for (SiddhiQueryGroup siddhiQueryGroup : siddhiQueryGroupsList) {
            String runtimeStreamDefinition;
            String topic;
            StreamDefinition streamDefinition;
            String streamId;
            for (Map.Entry<String, OutputStreamDataHolder> entry : siddhiQueryGroup.getOutputStreams().entrySet()) {
                OutputStreamDataHolder outputStreamDataHolder = entry.getValue();
                streamId = entry.getKey();
                streamDefinition = (StreamDefinition)this.siddhiApp.getStreamDefinitionMap().get(streamId);
                if (!outputStreamDataHolder.getEventHolderType().equals((Object)EventHolder.STREAM) || !outputStreamDataHolder.isUserGiven() || streamDefinition == null) continue;
                for (Annotation annotation : streamDefinition.getAnnotations()) {
                    if (!annotation.getName().equalsIgnoreCase("@sink".replace("@", "")) || !annotation.getElement("type").equalsIgnoreCase("inmemory")) continue;
                    topic = annotation.getElement("topic");
                    runtimeStreamDefinition = this.removeMetaInfoStream(streamId, outputStreamDataHolder.getStreamDefinition(), "@sink", "inmemory");
                    String outputStreamDefinition = "${" + streamId + "} " + runtimeStreamDefinition;
                    OutputStreamDataHolder streamDataHolder = new OutputStreamDataHolder(streamId, outputStreamDefinition, EventHolder.STREAM, false);
                    streamDataHolder.setInmemoryTopicName(topic);
                    streamDataHolder.addPublishingStrategy(new PublishingStrategyDataHolder(TransportStrategy.ALL, SiddhiTopologyCreatorConstants.DEFAULT_PARALLEL));
                    entry.setValue(streamDataHolder);
                }
            }
            for (Map.Entry<String, Object> entry : siddhiQueryGroup.getInputStreams().entrySet()) {
                InputStreamDataHolder inputStreamDataHolder = (InputStreamDataHolder)entry.getValue();
                streamId = entry.getKey();
                streamDefinition = (StreamDefinition)this.siddhiApp.getStreamDefinitionMap().get(streamId);
                if (!inputStreamDataHolder.getEventHolderType().equals((Object)EventHolder.STREAM) || !inputStreamDataHolder.isUserGiven() || streamDefinition == null) continue;
                for (Annotation annotation : streamDefinition.getAnnotations()) {
                    if (!annotation.getName().equalsIgnoreCase("@source".replace("@", "")) || !annotation.getElement("type").equalsIgnoreCase("inmemory")) continue;
                    topic = annotation.getElement("topic");
                    runtimeStreamDefinition = this.removeMetaInfoStream(streamId, inputStreamDataHolder.getStreamDefinition(), "@source", "inmemory");
                    String inputStreamDefinition = "${" + streamId + "} " + runtimeStreamDefinition;
                    inputStreamDataHolder.setStreamDefinition(inputStreamDefinition);
                    inputStreamDataHolder.setInMemoryTopic(topic);
                    inputStreamDataHolder.setUserGiven(false);
                }
            }
        }
    }

    private void cleanInnerGroupStreams(Collection<SiddhiQueryGroup> siddhiQueryGroups) {
        HashMap<String, String> dependentStreams = new HashMap<String, String>();
        for (SiddhiQueryGroup siddhiQueryGroup : siddhiQueryGroups) {
            for (Map.Entry<String, InputStreamDataHolder> entry : siddhiQueryGroup.getInputStreams().entrySet()) {
                String inputStreamName = entry.getKey();
                if (entry.getValue().getEventHolderType().equals((Object)EventHolder.AGGREGATION)) {
                    AggregationDefinition aggDef = (AggregationDefinition)this.siddhiApp.getAggregationDefinitionMap().get(inputStreamName);
                    String inputStreamId = aggDef.getBasicSingleInputStream().getStreamId();
                    String defaultStreamDef = ((StreamDefinition)this.siddhiApp.getStreamDefinitionMap().get(inputStreamId)).toString();
                    if (!this.isUserGivenTransport(defaultStreamDef)) {
                        if (siddhiQueryGroup.getInputStreams().get(inputStreamId) != null) {
                            siddhiQueryGroup.getInputStreams().get(inputStreamId).setStreamDefinition(defaultStreamDef);
                            siddhiQueryGroup.getInputStreams().get(inputStreamId).setInnerGroupStream(false);
                        } else {
                            dependentStreams.put(inputStreamId, defaultStreamDef);
                        }
                    }
                }
                if (!siddhiQueryGroup.getOutputStreams().containsKey(inputStreamName)) continue;
                siddhiQueryGroup.getOutputStreams().remove(inputStreamName);
            }
            for (Map.Entry<String, InputStreamDataHolder> entry : dependentStreams.entrySet()) {
                InputStreamDataHolder dependentInputStreamHolder = new InputStreamDataHolder(entry.getKey(), (String)((Object)entry.getValue()), EventHolder.STREAM, false, new SubscriptionStrategyDataHolder(1, TransportStrategy.ALL, null));
                dependentInputStreamHolder.setInnerGroupStream(false);
                siddhiQueryGroup.getInputStreams().put(entry.getKey(), dependentInputStreamHolder);
            }
            siddhiQueryGroup.getInputStreams().entrySet().removeIf(stringInputStreamDataHolderEntry -> ((InputStreamDataHolder)stringInputStreamDataHolderEntry.getValue()).isInnerGroupStream());
            siddhiQueryGroup.getOutputStreams().entrySet().removeIf(stringOutputStreamDataHolderEntry -> ((OutputStreamDataHolder)stringOutputStreamDataHolderEntry.getValue()).isInnerGroupStream());
        }
    }

    private String getSiddhiAppName() {
        Element element = AnnotationHelper.getAnnotationElement((String)"name", null, (List)this.siddhiApp.getAnnotations());
        if (element == null) {
            return "SiddhiApp-" + UUID.randomUUID();
        }
        return element.getValue();
    }

    private SiddhiQueryGroup createSiddhiQueryGroup(String execGroupName, int parallel) {
        SiddhiQueryGroup siddhiQueryGroup = !this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().containsKey(execGroupName) ? new SiddhiQueryGroup(execGroupName, parallel) : this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().get(execGroupName);
        return siddhiQueryGroup;
    }

    private String removeMetaInfoQuery(ExecutionElement executionElement, String queryElement) {
        for (Annotation annotation : executionElement.getAnnotations()) {
            if (!annotation.getName().toLowerCase().equals("dist")) continue;
            int[] queryContextStartIndex = annotation.getQueryContextStartIndex();
            int[] queryContextEndIndex = annotation.getQueryContextEndIndex();
            queryElement = queryElement.replace(ExceptionUtil.getContext((int[])queryContextStartIndex, (int[])queryContextEndIndex, (String)this.siddhiTopologyDataHolder.getUserDefinedSiddhiApp()), "");
            break;
        }
        return queryElement;
    }

    private Map<String, InputStreamDataHolder> getInputStreamHolderInfo(Query executionElement, SiddhiQueryGroup siddhiQueryGroup, boolean isQuery) {
        HashMap<String, InputStreamDataHolder> inputStreamDataHolderMap = new HashMap<String, InputStreamDataHolder>();
        int parallel = siddhiQueryGroup.getParallelism();
        String execGroupName = siddhiQueryGroup.getName();
        InputStream inputStream = executionElement.getInputStream();
        for (String inputStreamId : inputStream.getUniqueStreamIds()) {
            if (inputStreamId.startsWith("#")) continue;
            StreamDataHolder streamDataHolder = this.extractStreamHolderInfo(inputStreamId, execGroupName);
            TransportStrategy transportStrategy = TransportStrategy.ALL;
            InputStreamDataHolder inputStreamDataHolder = siddhiQueryGroup.getInputStreams().get(inputStreamId);
            String partitionKey = this.siddhiTopologyDataHolder.getPartitionKeyMap().get(inputStreamId);
            inputStreamDataHolder = new InputStreamDataHolder(inputStreamId, streamDataHolder.getStreamDefinition(), streamDataHolder.getEventHolderType(), streamDataHolder.isUserGiven(), new SubscriptionStrategyDataHolder(parallel, transportStrategy, partitionKey));
            inputStreamDataHolderMap.put(inputStreamId, inputStreamDataHolder);
        }
        return inputStreamDataHolderMap;
    }

    private OutputStreamDataHolder getOutputStreamHolderInfo(String outputStreamId, int parallel, String execGroupName) {
        if (!outputStreamId.startsWith("#")) {
            StreamDataHolder streamDataHolder = this.extractStreamHolderInfo(outputStreamId, execGroupName);
            return new OutputStreamDataHolder(outputStreamId, streamDataHolder.getStreamDefinition(), streamDataHolder.getEventHolderType(), streamDataHolder.isUserGiven());
        }
        return null;
    }

    private StreamDataHolder extractStreamHolderInfo(String streamId, String groupName) {
        StreamDataHolder streamDataHolder = new StreamDataHolder(true);
        Map streamDefinitionMap = this.siddhiApp.getStreamDefinitionMap();
        if (streamDefinitionMap.containsKey(streamId)) {
            int[] queryContextEndIndex;
            StreamDefinition definition = (StreamDefinition)streamDefinitionMap.get(streamId);
            int[] queryContextStartIndex = definition.getQueryContextStartIndex();
            String streamDefinition = ExceptionUtil.getContext((int[])queryContextStartIndex, (int[])(queryContextEndIndex = definition.getQueryContextEndIndex()), (String)this.siddhiTopologyDataHolder.getUserDefinedSiddhiApp());
            boolean isUserGivenTransport = this.isUserGivenTransport(streamDefinition);
            if (!isUserGivenTransport && !this.siddhiApp.getTriggerDefinitionMap().containsKey(streamId)) {
                streamDefinition = "${" + streamId + "}" + streamDefinition;
            }
            streamDataHolder = new StreamDataHolder(streamDefinition, EventHolder.STREAM, isUserGivenTransport);
        } else if (this.siddhiApp.getTableDefinitionMap().containsKey(streamId)) {
            AbstractDefinition tableDefinition = (AbstractDefinition)this.siddhiApp.getTableDefinitionMap().get(streamId);
            streamDataHolder.setEventHolderType(EventHolder.INMEMORYTABLE);
            for (Annotation annotation : tableDefinition.getAnnotations()) {
                if (!annotation.getName().toLowerCase().equals("store")) continue;
                streamDataHolder.setEventHolderType(EventHolder.TABLE);
                this.siddhiTopologyDataHolder.setStatefulApp(true);
                break;
            }
            int[] queryContextStartIndex = ((TableDefinition)this.siddhiApp.getTableDefinitionMap().get(streamId)).getQueryContextStartIndex();
            int[] queryContextEndIndex = ((TableDefinition)this.siddhiApp.getTableDefinitionMap().get(streamId)).getQueryContextEndIndex();
            streamDataHolder.setStreamDefinition(ExceptionUtil.getContext((int[])queryContextStartIndex, (int[])queryContextEndIndex, (String)this.siddhiTopologyDataHolder.getUserDefinedSiddhiApp()));
            if (!streamDataHolder.getEventHolderType().equals((Object)EventHolder.INMEMORYTABLE) && !this.siddhiTopologyDataHolder.getInMemoryMap().containsKey(streamId)) {
                this.siddhiTopologyDataHolder.getInMemoryMap().put(streamId, groupName);
            }
        } else if (this.siddhiApp.getWindowDefinitionMap().containsKey(streamId)) {
            this.siddhiTopologyDataHolder.setStatefulApp(true);
            int[] queryContextStartIndex = ((WindowDefinition)this.siddhiApp.getWindowDefinitionMap().get(streamId)).getQueryContextStartIndex();
            int[] queryContextEndIndex = ((WindowDefinition)this.siddhiApp.getWindowDefinitionMap().get(streamId)).getQueryContextEndIndex();
            streamDataHolder.setStreamDefinition(ExceptionUtil.getContext((int[])queryContextStartIndex, (int[])queryContextEndIndex, (String)this.siddhiTopologyDataHolder.getUserDefinedSiddhiApp()));
            streamDataHolder.setEventHolderType(EventHolder.WINDOW);
            if (!this.siddhiTopologyDataHolder.getInMemoryMap().containsKey(streamId)) {
                this.siddhiTopologyDataHolder.getInMemoryMap().put(streamId, groupName);
            }
        } else if (this.siddhiApp.getAggregationDefinitionMap().containsKey(streamId)) {
            AggregationDefinition aggregationDefinition = (AggregationDefinition)this.siddhiApp.getAggregationDefinitionMap().get(streamId);
            this.siddhiTopologyDataHolder.setStatefulApp(true);
            int[] queryContextStartIndex = aggregationDefinition.getQueryContextStartIndex();
            int[] queryContextEndIndex = aggregationDefinition.getQueryContextEndIndex();
            streamDataHolder.setStreamDefinition(ExceptionUtil.getContext((int[])queryContextStartIndex, (int[])queryContextEndIndex, (String)this.siddhiTopologyDataHolder.getUserDefinedSiddhiApp()));
            String outputStreamId = aggregationDefinition.getBasicSingleInputStream().getStreamId();
            streamDataHolder.setEventHolderType(EventHolder.AGGREGATION);
            if (!this.siddhiTopologyDataHolder.getInMemoryMap().containsKey(streamId)) {
                this.siddhiTopologyDataHolder.getInMemoryMap().put(streamId, groupName);
            }
            if (!this.siddhiTopologyDataHolder.getInMemoryMap().containsKey(outputStreamId)) {
                this.siddhiTopologyDataHolder.getInMemoryMap().put(outputStreamId, groupName);
            }
        } else if (streamDataHolder.getStreamDefinition() == null && this.siddhiAppRuntime.getStreamDefinitionMap().containsKey(streamId)) {
            streamDataHolder = new StreamDataHolder("${" + streamId + "}" + ((StreamDefinition)this.siddhiAppRuntime.getStreamDefinitionMap().get(streamId)).toString(), EventHolder.STREAM, false);
        }
        return streamDataHolder;
    }

    private boolean isUserGivenTransport(String streamDefinition) {
        return streamDefinition.toLowerCase().contains("@source") || streamDefinition.toLowerCase().contains("@sink");
    }

    private void checkUserGivenSourceDistribution() {
        boolean passthroughQueriesAvailable = false;
        boolean isInmemoryBridged = false;
        ArrayList<SiddhiQueryGroup> siddhiQueryGroupsList = new ArrayList<SiddhiQueryGroup>(this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().values());
        for (SiddhiQueryGroup siddhiQueryGroup : siddhiQueryGroupsList) {
            for (Map.Entry<String, InputStreamDataHolder> entry : siddhiQueryGroup.getInputStreams().entrySet()) {
                String streamId = entry.getKey();
                InputStreamDataHolder inputStreamDataHolder = entry.getValue();
                if (inputStreamDataHolder.getEventHolderType() == null || !inputStreamDataHolder.getEventHolderType().equals((Object)EventHolder.STREAM) || !inputStreamDataHolder.isUserGivenSource()) continue;
                String runtimeDefinition = this.removeMetaInfoStream(streamId, inputStreamDataHolder.getStreamDefinition(), "@source", null);
                runtimeDefinition = this.removeMetaInfoStream(streamId, runtimeDefinition, "@sink", null);
                StreamDefinition streamDefinition = (StreamDefinition)this.siddhiAppRuntime.getStreamDefinitionMap().get(inputStreamDataHolder.getStreamName());
                int nonMessagingSources = 0;
                for (Annotation annotation : streamDefinition.getAnnotations()) {
                    if (!annotation.getName().equalsIgnoreCase("@source".replace("@", ""))) continue;
                    if (annotation.getElement("type").equalsIgnoreCase(DEFAULT_MESSAGING_SYSTEM)) {
                        siddhiQueryGroup.setMessagingSourceAvailable(true);
                        continue;
                    }
                    if (annotation.getElement("type").equalsIgnoreCase("inmemory")) {
                        isInmemoryBridged = true;
                        continue;
                    }
                    ++nonMessagingSources;
                }
                if ((siddhiQueryGroup.isMessagingSourceAvailable() || isInmemoryBridged) && nonMessagingSources <= 0 || !this.isStatefulApp()) continue;
                passthroughQueriesAvailable = true;
                this.generatePassthroughQueryList(inputStreamDataHolder, runtimeDefinition);
                inputStreamDataHolder.setStreamDefinition(runtimeDefinition);
                inputStreamDataHolder.setUserGiven(false);
                InputStreamDataHolder holder = siddhiQueryGroup.getInputStreams().get(streamId);
                String consumingStream = "${" + streamId + "} " + this.removeMetaInfoStream(streamId, holder.getStreamDefinition(), "@source", null);
                holder.setStreamDefinition(consumingStream);
                holder.setUserGiven(false);
            }
        }
        if (passthroughQueriesAvailable) {
            this.addFirst(this.passThroughSiddhiQueryGroup);
        }
    }

    private void generatePassthroughQueryList(InputStreamDataHolder inputStreamDataHolder, String runtimeDefinition) {
        this.createPassthroughQueryGroup(inputStreamDataHolder, runtimeDefinition, SiddhiTopologyCreatorConstants.DEFAULT_PARALLEL);
        this.passThroughSiddhiQueryGroup.setReceiverQueryGroup(true);
    }

    private String removeMetaInfoStream(String streamId, String streamDefinition, String identifier, String type) {
        for (Annotation annotation : ((StreamDefinition)this.siddhiApp.getStreamDefinitionMap().get(streamId)).getAnnotations()) {
            if (!annotation.getName().toLowerCase().equals(identifier.replace("@", "")) || !annotation.getElement("type").equalsIgnoreCase(type) && type != null) continue;
            int[] queryContextStartIndex = annotation.getQueryContextStartIndex();
            int[] queryContextEndIndex = annotation.getQueryContextEndIndex();
            streamDefinition = streamDefinition.replace(ExceptionUtil.getContext((int[])queryContextStartIndex, (int[])queryContextEndIndex, (String)this.siddhiTopologyDataHolder.getUserDefinedSiddhiApp()), "");
        }
        return streamDefinition;
    }

    private void addFirst(SiddhiQueryGroup passthroughSiddhiQueryGroup) {
        LinkedHashMap<String, SiddhiQueryGroup> output = new LinkedHashMap<String, SiddhiQueryGroup>();
        output.put(passthroughSiddhiQueryGroup.getName(), passthroughSiddhiQueryGroup);
        output.putAll(this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap());
        this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().clear();
        this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().putAll(output);
    }

    private void createPassthroughQueryGroup(InputStreamDataHolder inputStreamDataHolder, String runtimeDefinition, int parallelism) {
        String streamId = inputStreamDataHolder.getStreamName();
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        String inputStreamID = "passthrough" + inputStreamDataHolder.getStreamName();
        valuesMap.put("inputStreamID", inputStreamID);
        valuesMap.put("outputStreamID", streamId);
        StrSubstitutor substitutor = new StrSubstitutor(valuesMap);
        String passThroughQuery = substitutor.replace("from ${inputStreamID} select * insert into ${outputStreamID}");
        this.passThroughSiddhiQueryGroup.addQuery(passThroughQuery);
        String inputStreamDefinition = inputStreamDataHolder.getStreamDefinition().replace(streamId, inputStreamID);
        String outputStreamDefinition = "${" + streamId + "} " + runtimeDefinition;
        this.passThroughSiddhiQueryGroup.getInputStreams().put(inputStreamID, new InputStreamDataHolder(inputStreamID, inputStreamDefinition, EventHolder.STREAM, true, new SubscriptionStrategyDataHolder(SiddhiTopologyCreatorConstants.DEFAULT_PARALLEL, TransportStrategy.ALL, null)));
        this.passThroughSiddhiQueryGroup.getOutputStreams().put(streamId, new OutputStreamDataHolder(streamId, outputStreamDefinition, EventHolder.STREAM, false));
    }

    private void addExecutionElement(ExecutionElement executionElement, SiddhiQueryGroup siddhiQueryGroup, String queryGroupName) {
        int parallelism = siddhiQueryGroup.getParallelism();
        if (executionElement instanceof Query) {
            int[] queryContextStartIndex = ((Query)executionElement).getQueryContextStartIndex();
            int[] queryContextEndIndex = ((Query)executionElement).getQueryContextEndIndex();
            siddhiQueryGroup.addQuery(this.removeMetaInfoQuery(executionElement, ExceptionUtil.getContext((int[])queryContextStartIndex, (int[])queryContextEndIndex, (String)this.userDefinedSiddhiApp)));
            siddhiQueryGroup.addInputStreams(this.getInputStreamHolderInfo((Query)executionElement, siddhiQueryGroup, true));
            String outputStreamId = ((Query)executionElement).getOutputStream().getId();
            siddhiQueryGroup.addOutputStream(outputStreamId, this.getOutputStreamHolderInfo(outputStreamId, parallelism, queryGroupName));
        } else if (executionElement instanceof Partition) {
            int[] queryContextStartIndex = ((Partition)executionElement).getQueryContextStartIndex();
            int[] queryContextEndIndex = ((Partition)executionElement).getQueryContextEndIndex();
            siddhiQueryGroup.addQuery(this.removeMetaInfoQuery(executionElement, ExceptionUtil.getContext((int[])queryContextStartIndex, (int[])queryContextEndIndex, (String)this.userDefinedSiddhiApp)));
            this.storePartitionInfo((Partition)executionElement, queryGroupName);
            for (Query query : ((Partition)executionElement).getQueryList()) {
                siddhiQueryGroup.addInputStreams(this.getInputStreamHolderInfo(query, siddhiQueryGroup, false));
                String outputStreamId = query.getOutputStream().getId();
                siddhiQueryGroup.addOutputStream(outputStreamId, this.getOutputStreamHolderInfo(outputStreamId, parallelism, queryGroupName));
            }
        }
        this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().put(queryGroupName, siddhiQueryGroup);
    }

    private void assignPublishingStrategyOutputStream() {
        int i = 0;
        ArrayList<SiddhiQueryGroup> siddhiQueryGroupsList = new ArrayList<SiddhiQueryGroup>(this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().values());
        for (SiddhiQueryGroup siddhiQueryGroup1 : siddhiQueryGroupsList) {
            for (Map.Entry<String, OutputStreamDataHolder> entry : siddhiQueryGroup1.getOutputStreams().entrySet()) {
                OutputStreamDataHolder outputStreamDataHolder = entry.getValue();
                String streamId = entry.getKey();
                if (!outputStreamDataHolder.getEventHolderType().equals((Object)EventHolder.STREAM)) continue;
                HashMap fieldGroupingSubscriptions = new HashMap();
                boolean isInnerGroupStream = true;
                for (SiddhiQueryGroup siddhiQueryGroup : siddhiQueryGroupsList.subList(i + 1, siddhiQueryGroupsList.size())) {
                    SubscriptionStrategyDataHolder subscriptionStrategy;
                    if (!siddhiQueryGroup.getInputStreams().containsKey(streamId)) continue;
                    isInnerGroupStream = false;
                    InputStreamDataHolder inputStreamDataHolder = siddhiQueryGroup.getInputStreams().get(streamId);
                    if (outputStreamDataHolder.isUserGiven()) {
                        String runtimeStreamDefinition = this.removeMetaInfoStream(streamId, inputStreamDataHolder.getStreamDefinition(), "@sink", null);
                        if (!outputStreamDataHolder.isSinkBridgeAdded()) {
                            String outputStreamDefinition = outputStreamDataHolder.getStreamDefinition().replace(runtimeStreamDefinition, "\n${" + streamId + "} ") + runtimeStreamDefinition;
                            outputStreamDataHolder.setStreamDefinition(outputStreamDefinition);
                            outputStreamDataHolder.setSinkBridgeAdded(true);
                        }
                        inputStreamDataHolder.setStreamDefinition("${" + streamId + "} " + runtimeStreamDefinition);
                        inputStreamDataHolder.setUserGiven(false);
                    }
                    if ((subscriptionStrategy = inputStreamDataHolder.getSubscriptionStrategy()).getStrategy().equals((Object)TransportStrategy.FIELD_GROUPING)) {
                        String partitionKey = subscriptionStrategy.getPartitionKey();
                        if (fieldGroupingSubscriptions.containsKey(partitionKey)) {
                            ((List)fieldGroupingSubscriptions.get(partitionKey)).add(subscriptionStrategy);
                            continue;
                        }
                        ArrayList<SubscriptionStrategyDataHolder> strategyList = new ArrayList<SubscriptionStrategyDataHolder>();
                        strategyList.add(subscriptionStrategy);
                        fieldGroupingSubscriptions.put(partitionKey, strategyList);
                        continue;
                    }
                    outputStreamDataHolder.addPublishingStrategy(new PublishingStrategyDataHolder(subscriptionStrategy.getStrategy(), siddhiQueryGroup.getParallelism()));
                }
                if (isInnerGroupStream && !outputStreamDataHolder.isUserGiven()) {
                    siddhiQueryGroup1.getOutputStreams().get(streamId).setInnerGroupStream(true);
                    if (siddhiQueryGroup1.getInputStreams().get(streamId) != null) {
                        siddhiQueryGroup1.getInputStreams().get(streamId).setInnerGroupStream(true);
                    }
                }
                for (Map.Entry entry2 : fieldGroupingSubscriptions.entrySet()) {
                    String partitionKey = (String)entry2.getKey();
                    List strategyList = (List)entry2.getValue();
                    strategyList.sort(new StrategyParallelismComparator().reversed());
                    int parallelism = ((SubscriptionStrategyDataHolder)strategyList.get(0)).getOfferedParallelism();
                    for (SubscriptionStrategyDataHolder holder : strategyList) {
                        holder.setOfferedParallelism(parallelism);
                    }
                    outputStreamDataHolder.addPublishingStrategy(new PublishingStrategyDataHolder(TransportStrategy.FIELD_GROUPING, partitionKey, parallelism));
                }
            }
            ++i;
        }
    }

    private void storePartitionInfo(Partition partition, String execGroupName) {
        for (Map.Entry partitionTypeEntry : partition.getPartitionTypeMap().entrySet()) {
            String streamID = (String)partitionTypeEntry.getKey();
            List<String> partitionGroupList = this.siddhiTopologyDataHolder.getPartitionGroupMap().containsKey(streamID) ? this.siddhiTopologyDataHolder.getPartitionGroupMap().get(streamID) : new ArrayList<String>();
            partitionGroupList.add(execGroupName);
            this.siddhiTopologyDataHolder.getPartitionGroupMap().put(streamID, partitionGroupList);
            if (partitionTypeEntry.getValue() instanceof ValuePartitionType) {
                String partitionKey = ((Variable)((ValuePartitionType)partitionTypeEntry.getValue()).getExpression()).getAttributeName();
                if (this.siddhiTopologyDataHolder.getPartitionKeyGroupMap().get(streamID + partitionKey) != null && this.siddhiTopologyDataHolder.getPartitionKeyGroupMap().get(streamID + partitionKey).equals(execGroupName)) {
                    throw new SiddhiAppValidationException("Unsupported in distributed setup :More than 1 partition residing on the same execGroup " + execGroupName + " for " + streamID + " " + partitionKey);
                }
                this.siddhiTopologyDataHolder.getPartitionKeyGroupMap().put(streamID + partitionKey, execGroupName);
                this.siddhiTopologyDataHolder.getPartitionKeyMap().put(streamID, partitionKey);
                this.updateInputStreamDataHolders(streamID, partitionKey);
                continue;
            }
            throw new SiddhiAppValidationException("Unsupported: " + execGroupName + " Range PartitionType not Supported in Distributed SetUp");
        }
    }

    private void updateInputStreamDataHolders(String streamID, String partitionKey) {
        for (SiddhiQueryGroup siddhiQueryGroup : this.siddhiTopologyDataHolder.getSiddhiQueryGroupMap().values()) {
            InputStreamDataHolder holder = siddhiQueryGroup.getInputStreams().get(streamID);
            if (holder == null || holder.getSubscriptionStrategy().getStrategy() == TransportStrategy.FIELD_GROUPING) continue;
            holder.getSubscriptionStrategy().setPartitionKey(partitionKey);
        }
    }
}

