/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.parser.service;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.SiddhiManager;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.util.config.ConfigManager;
import io.siddhi.distribution.common.common.SiddhiAppRuntimeService;
import io.siddhi.distribution.common.common.utils.config.FileConfigManager;
import io.siddhi.parser.SiddhiParserDataHolder;
import io.siddhi.parser.core.SiddhiAppCreator;
import io.siddhi.parser.core.SiddhiTopologyCreator;
import io.siddhi.parser.core.appcreator.DeployableSiddhiQueryGroup;
import io.siddhi.parser.core.appcreator.NatsSiddhiAppCreator;
import io.siddhi.parser.core.appcreator.SiddhiQuery;
import io.siddhi.parser.core.topology.SiddhiTopology;
import io.siddhi.parser.core.topology.SiddhiTopologyCreatorImpl;
import io.siddhi.parser.service.model.ApiResponseMessage;
import io.siddhi.parser.service.model.DeployableSiddhiApp;
import io.siddhi.parser.service.model.MessagingSystem;
import io.siddhi.parser.service.model.SiddhiParserRequest;
import io.siddhi.parser.service.model.SourceDeploymentConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.kernel.config.model.CarbonConfiguration;
import org.wso2.msf4j.MicroservicesRunner;
import org.wso2.transport.http.netty.contract.config.TransportsConfiguration;

@Path(value="/siddhi-parser")
@Component(name="siddhi-parser-service", immediate=true)
public class SiddhiParserApi {
    private static final Logger log = LoggerFactory.getLogger(SiddhiParserApi.class);
    private static final String TRANSPORT_ROOT_CONFIG_ELEMENT = "wso2.transport.http";
    private static final String SIDDHI_PARSER_ACTIVATION_SYS_PROPERTY = "siddhi-parser";
    private static TransportsConfiguration transportsConfiguration;
    private MicroservicesRunner microservicesRunner;
    private volatile boolean microserviceActive;
    private static SiddhiAppCreator appCreator;
    private static SiddhiTopologyCreator siddhiTopologyCreator;

    @GET
    @Path(value="/")
    public String get() {
        return "Siddhi Parser Service is up and running.";
    }

    @POST
    @Path(value="/parse")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response parseSiddhiApp(SiddhiParserRequest request) throws NotFoundException {
        try {
            ArrayList<DeployableSiddhiApp> deployableSiddhiApps = new ArrayList<DeployableSiddhiApp>();
            List<String> userGivenApps = this.populateAppWithEnvs(request.getPropertyMap(), request.getSiddhiApps());
            for (String app : userGivenApps) {
                Set<SourceDeploymentConfig> sourceDeploymentConfigs = this.getSourceDeploymentConfigs(app);
                MessagingSystem messagingSystemConfig = request.getMessagingSystem();
                if (messagingSystemConfig != null && !messagingSystemConfig.isEmpty()) {
                    SiddhiTopology topology = siddhiTopologyCreator.createTopology(app);
                    boolean isAppStateful = topology.isStatefulApp();
                    List<DeployableSiddhiQueryGroup> queryGroupList = appCreator.createApps(topology, messagingSystemConfig);
                    if (!queryGroupList.isEmpty()) {
                        for (DeployableSiddhiQueryGroup deployableSiddhiQueryGroup : queryGroupList) {
                            if (deployableSiddhiQueryGroup.isReceiverQueryGroup()) {
                                for (SiddhiQuery siddhiQuery : deployableSiddhiQueryGroup.getSiddhiQueries()) {
                                    deployableSiddhiApps.add(new DeployableSiddhiApp(siddhiQuery.getApp(), sourceDeploymentConfigs, topology.isUserGiveSourceStateful()));
                                }
                                continue;
                            }
                            for (SiddhiQuery siddhiQuery : deployableSiddhiQueryGroup.getSiddhiQueries()) {
                                DeployableSiddhiApp deployableSiddhiApp = new DeployableSiddhiApp(siddhiQuery.getApp(), isAppStateful);
                                if (deployableSiddhiQueryGroup.isUserGivenSource()) {
                                    deployableSiddhiApp.setSourceDeploymentConfigs(sourceDeploymentConfigs);
                                }
                                deployableSiddhiApps.add(deployableSiddhiApp);
                            }
                        }
                        continue;
                    }
                    deployableSiddhiApps.add(this.createStandaloneDeployableApp(app, sourceDeploymentConfigs));
                    continue;
                }
                deployableSiddhiApps.add(this.createStandaloneDeployableApp(app, sourceDeploymentConfigs));
            }
            return Response.ok().entity(deployableSiddhiApps).build();
        }
        catch (Exception e) {
            log.error("Exception caught while parsing the app. " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ApiResponseMessage(1, "Exception caught while parsing the app. " + e.getMessage())).build();
        }
    }

    private DeployableSiddhiApp createStandaloneDeployableApp(String app, Set<SourceDeploymentConfig> sourceDeploymentConfigs) {
        DeployableSiddhiApp deployableSiddhiApp = new DeployableSiddhiApp(app, siddhiTopologyCreator.isAppStateful(app));
        if (sourceDeploymentConfigs != null && sourceDeploymentConfigs.size() != 0) {
            deployableSiddhiApp.setSourceDeploymentConfigs(sourceDeploymentConfigs);
        }
        return deployableSiddhiApp;
    }

    private List<String> populateAppWithEnvs(Map<String, String> envMap, List<String> siddhiApps) {
        ArrayList<String> populatedApps = new ArrayList<String>();
        if (siddhiApps != null) {
            for (String siddhiApp : siddhiApps) {
                if (siddhiApp.contains("$") && envMap != null) {
                    String envPattern = "\\$\\{(\\w+)\\}";
                    Pattern expr = Pattern.compile(envPattern);
                    Matcher matcher = expr.matcher(siddhiApp);
                    while (matcher.find()) {
                        for (int i = 1; i <= matcher.groupCount(); ++i) {
                            if (envMap.get(matcher.group(i)) == null) continue;
                            String envValue = envMap.get(matcher.group(i));
                            envValue = envValue.replace("\\", "\\\\");
                            Pattern subexpr = Pattern.compile("\\$\\{" + matcher.group(i) + "\\}");
                            siddhiApp = subexpr.matcher(siddhiApp).replaceAll(envValue);
                        }
                    }
                }
                populatedApps.add(siddhiApp);
            }
        }
        return populatedApps;
    }

    private Set<SourceDeploymentConfig> getSourceDeploymentConfigs(String siddhiApp) {
        HashSet<SourceDeploymentConfig> sourceDeploymentConfigs = new HashSet<SourceDeploymentConfig>();
        SiddhiAppRuntime siddhiAppRuntime = SiddhiParserDataHolder.getSiddhiManager().createSiddhiAppRuntime(siddhiApp);
        Collection sources = siddhiAppRuntime.getSources();
        for (List sourceList : sources) {
            for (Source source : sourceList) {
                ServiceDeploymentInfo serviceDeploymentInfo = source.getServiceDeploymentInfo();
                if (serviceDeploymentInfo == null) continue;
                SourceDeploymentConfig response = new SourceDeploymentConfig(serviceDeploymentInfo.getPort(), serviceDeploymentInfo.getServiceProtocol().name(), serviceDeploymentInfo.isSecured(), serviceDeploymentInfo.isPulling(), serviceDeploymentInfo.getDeploymentProperties());
                sourceDeploymentConfigs.add(response);
            }
        }
        return sourceDeploymentConfigs;
    }

    @Activate
    protected void start(BundleContext bundleContext) throws Exception {
        if (transportsConfiguration != null) {
            this.microservicesRunner = new MicroservicesRunner(transportsConfiguration);
        }
        String toolIdentifier = System.getProperty(SIDDHI_PARSER_ACTIVATION_SYS_PROPERTY);
        Optional.ofNullable(toolIdentifier).ifPresent(identifier -> this.startParserApiMicroservice());
    }

    @Deactivate
    protected void stop() throws Exception {
        log.debug("Siddhi Parser API deactivated.");
        this.stopParserApiMicroservice();
    }

    public void startParserApiMicroservice() {
        SiddhiManager siddhiManager = SiddhiParserDataHolder.getSiddhiManager();
        FileConfigManager fileConfigManager = new FileConfigManager(SiddhiParserDataHolder.getConfigProvider());
        siddhiManager.setConfigManager((ConfigManager)fileConfigManager);
        SiddhiParserDataHolder.setSiddhiManager(siddhiManager);
        if (this.microservicesRunner != null && !this.microserviceActive) {
            this.microservicesRunner.deploy(new Object[]{new SiddhiParserApi()});
            this.microservicesRunner.start();
            this.microserviceActive = true;
        }
        log.info("Siddhi Parser REST API activated.");
    }

    public void stopParserApiMicroservice() {
        if (this.microservicesRunner != null && this.microserviceActive) {
            this.microservicesRunner.stop();
            this.microserviceActive = false;
        }
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        SiddhiParserDataHolder.setConfigProvider(configProvider);
        try {
            transportsConfiguration = (TransportsConfiguration)configProvider.getConfigurationObject(TRANSPORT_ROOT_CONFIG_ELEMENT, TransportsConfiguration.class);
            CarbonConfiguration carbonConfig = (CarbonConfiguration)configProvider.getConfigurationObject(CarbonConfiguration.class);
            transportsConfiguration.getListenerConfigurations().forEach(listenerConfiguration -> listenerConfiguration.setPort(listenerConfiguration.getPort() + carbonConfig.getPortsConfig().getOffset()));
        }
        catch (ConfigurationException e) {
            log.error("Error while loading TransportsConfiguration for wso2.transport.http", (Throwable)e);
        }
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
        SiddhiParserDataHolder.setConfigProvider(null);
    }

    @Reference(name="siddhi.app.runtime.service.reference", service=SiddhiAppRuntimeService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetSiddhiAppRuntimeService")
    protected void setSiddhiAppRuntimeService(SiddhiAppRuntimeService siddhiAppRuntimeService) {
    }

    protected void unsetSiddhiAppRuntimeService(SiddhiAppRuntimeService siddhiAppRuntimeService) {
    }

    @Reference(name="siddhi-manager-service", service=SiddhiManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSiddhiManager")
    protected void setSiddhiManager(SiddhiManager siddhiManager) {
        SiddhiParserDataHolder.setSiddhiManager(siddhiManager);
    }

    protected void unsetSiddhiManager(SiddhiManager siddhiManager) {
        SiddhiParserDataHolder.setSiddhiManager(null);
    }

    static {
        appCreator = new NatsSiddhiAppCreator();
        siddhiTopologyCreator = new SiddhiTopologyCreatorImpl();
    }
}

