/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.servervariable;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;

public class ServerVariableWriter {
    private ServerVariableWriter() {
    }

    public static void writeServerVariables(ObjectNode serverNode, Map<String, ServerVariable> variables) {
        if (variables == null) {
            return;
        }
        ObjectNode variablesNode = serverNode.putObject("variables");
        Set<Map.Entry<String, ServerVariable>> entrySet = variables.entrySet();
        for (Map.Entry<String, ServerVariable> entry : entrySet) {
            ServerVariableWriter.writeServerVariable(variablesNode, entry.getValue(), entry.getKey());
        }
    }

    public static void writeServerVariable(ObjectNode parent, ServerVariable model, String variableName) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(variableName);
        JsonUtil.stringProperty(node, "default", model.getDefaultValue());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        List enumeration = model.getEnumeration();
        if (enumeration != null) {
            ArrayNode enumArray = node.putArray("enum");
            for (String enumValue : enumeration) {
                enumArray.add(enumValue);
            }
        }
        ExtensionWriter.writeExtensions(node, model);
    }
}

